<!-- ======= Hero Sectin-->
<section id="hero" class="hero d-flex align-items-center">

    <div class="container">
        <div class="row">
            <div class="col-lg-6 d-flex flex-column justify-content-center">
                <h1 data-aos="fade-up">Simplify Your Payment Management</h1>
                <h2 data-aos="fade-up" data-aos-delay="400">Join us to experience efficient and secure payment solutions for your business</h2>
                <div data-aos="fade-up" data-aos-delay="600">
                    <div class="text-center text-lg-start">
                        <a href="/sign-up" class="btn-get-started scrollto d-inline-flex align-items-center justify-content-center align-self-center">
                            <span>Get Started</span>
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 order-1 order-lg-2 hero-img" data-aos="zoom-out">
            
            <img src="<?= base_url('public/assets/plat') ?>/jonotapayhone.jpg" class="img-fluid animated" alt="">
          </div> 
            
        </div>
    </div>

</section><!-- End Hero -->



<main id="main">

<section id="about" class="values">
    <div class="container" data-aos="fade-up">
        <header class="section-header">
            <h2>We Offer</h2>
            <p>Our guiding principles that empower seamless payment solutions</p>
        </header>

        <div class="row">
            <div class="col-lg-4" data-aos="fade-up" data-aos-delay="200">
                <div class="box">
                    <img src="<?= base_url('public/assets/plat') ?>/tt.png" class="img-fluid" alt="">
                    <h3>Save Time</h3>
                    <p>Simplify your payment processes and save valuable time with our integrated MFS API, ensuring fast and efficient transactions.</p>
                </div>
            </div>

            <div class="col-lg-4 mt-4 mt-lg-0" data-aos="fade-up" data-aos-delay="400">
                <div class="box">
                    <img src="<?= base_url('public/assets/plat') ?>/nh.png" class="img-fluid" alt="">
                    <h3>Seamless Integration</h3>
                    <p>Easily connect and integrate with our system. Automate workflows, link applications, and manage data sources effortlessly.</p>
                </div>
            </div>

            <div class="col-lg-4 mt-4 mt-lg-0" data-aos="fade-up" data-aos-delay="600">
                <div class="box">
                    <img src="<?= base_url('public/assets/plat') ?>/mm.png" class="img-fluid" alt="">
                    <h3>Automate Personal Accounts</h3>
                    <p>Streamline your payment reception with Pay Online Bd automation. Direct payments to your personal account without manual intervention.</p>
                </div>
            </div>

            <div class="col-lg-4 mt-4 mt-lg-0" data-aos="fade-up" data-aos-delay="800">
                <div class="box">
                    <img src="<?= base_url('public/assets/plat') ?>/5644447.png" class="img-fluid" alt="">
                    <h3>Invoice Generator</h3>
                    <p>Create and send personalized payment links via email for quick and easy payments, eliminating the need for a website or online store.</p>
                </div>
            </div>

            <div class="col-lg-4 mt-4 mt-lg-0" data-aos="fade-up" data-aos-delay="1000">
                <div class="box">
                    <img src="<?= base_url('public/assets/plat') ?>/6221918.png" class="img-fluid" alt="">
                    <h3>Billing Management</h3>
                    <p>Simplify billing with Pay In Pay Online Bd automated system. Monitor transactions, generate invoices, and streamline your billing process efficiently.</p>
                </div>
            </div>

            <div class="col-lg-4 mt-4 mt-lg-0" data-aos="fade-up" data-aos-delay="1200">
                <div class="box">
                    <img src="<?= base_url('public/assets/plat') ?>/2903544.png" class="img-fluid" alt="">
                    <h3>Multiple Payment Options</h3>
                    <p>Offer your customers various payment methods, including Mobile Banking and Bank Transfers, through BD AUTO PAY versatile platform.</p>
                </div>
            </div>

            
        </div>
    </div>
</section><!-- End Values Section -->



    <section id="counts" class="counts">
    <div class="container" data-aos="fade-up">

        <div class="row gy-4">

            <div class="col-lg-3 col-md-6">
                <div class="count-box">
                    <!-- Updated icon -->
                    <i class="bi bi-people-fill"></i>
                    <div>
                        <span data-purecounter-start="0" data-purecounter-end="1963" data-purecounter-duration="1" class="purecounter"></span>
                        <p>Happy Clients</p>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="count-box">
                    <!-- Updated icon -->
                    <i class="bi bi-book-half" style="color: #ee6c20;"></i>
                    <div>
                        <span data-purecounter-start="0" data-purecounter-end="6" data-purecounter-duration="1" class="purecounter"></span>
                        <p>Plans</p>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="count-box">
                    <!-- Updated icon -->
                    <i class="bi bi-graph-up" style="color: #15be56;"></i>
                    <div>
                        <span data-purecounter-start="0" data-purecounter-end="3287490" data-purecounter-duration="1" class="purecounter"></span>
                        <p>Total Amount Transactions</p>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="count-box">
                    <!-- Updated icon -->
                    <i class="bi bi-credit-card" style="color: #bb0852;"></i>
                    <div>
                        <span data-purecounter-start="0" data-purecounter-end="12" data-purecounter-duration="1" class="purecounter"></span>
                        <p>Supported Payment Methods</p>
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>

    <section id="features" class="features">

    <div class="container" data-aos="fade-up">

        <header class="section-header">
            <h2>Features</h2>
            <p>Advanced capabilities for streamlined payments</p>
        </header>

        <div class="row">

              <div class="col-xl-6" data-aos="zoom-out" data-aos-delay="100">
            
            <img src="<?= base_url('public/assets/plat') ?>/13429923.jpg" class="img-fluid" alt="">
          </div> 
                

            <div class="col-lg-6 mt-5 mt-lg-0 d-flex">
                <div class="row align-self-center gy-4">

                    <div class="col-md-6" data-aos="zoom-out" data-aos-delay="200">
                        <div class="feature-box d-flex align-items-center">
                            <i class="bi bi-speedometer2"></i>
                            <h3>Real-Time Processing</h3>
                        </div>
                    </div>

                    <div class="col-md-6" data-aos="zoom-out" data-aos-delay="300">
                        <div class="feature-box d-flex align-items-center">
                            <i class="bi bi-shield-lock"></i>
                            <h3>High Security</h3>
                        </div>
                    </div>

                    <div class="col-md-6" data-aos="zoom-out" data-aos-delay="400">
                        <div class="feature-box d-flex align-items-center">
                            <i class="bi bi-arrows-expand"></i>
                            <h3>Scalability</h3>
                        </div>
                    </div>

                  

                    <div class="col-md-6" data-aos="zoom-out" data-aos-delay="600">
                        <div class="feature-box d-flex align-items-center">
                            <i class="bi bi-link"></i>
                            <h3>Seamless Integration</h3>
                        </div>
                    </div>

                    <div class="col-md-6" data-aos="zoom-out" data-aos-delay="700">
                        <div class="feature-box d-flex align-items-center">
                            <i class="bi bi-graph-up"></i>
                            <h3>Comprehensive Reporting</h3>
                        </div>
                    </div>

                    <div class="col-md-6" data-aos="zoom-out" data-aos-delay="800">
                        <div class="feature-box d-flex align-items-center">
                            <i class="bi bi-check-circle"></i>
                            <h3>Automatic Payment Verification</h3>
                        </div>
                    </div>

                    <div class="col-md-6" data-aos="zoom-out" data-aos-delay="900">
                        <div class="feature-box d-flex align-items-center">
                            <i class="bi bi-cash"></i>
                            <h3>No Transaction Fees</h3>
                        </div>
                    </div>

                </div>
            </div>

        </div> <!-- / row -->

    </div>

</section><!-- End Features Section -->
<section id="services" class="services">

    <div class="container" data-aos="fade-up">

        <header class="section-header">
            <h2>Services</h2>
            <p>Explore our range of services</p>
        </header>

        <div class="row mt-5">

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
                <div class="service-box blue">
                    <i class="bi bi-lightning-charge-fill icon"></i>
                    <h3>Instant Payment</h3>
                    <p>After the customer makes the payment through Payonlinebd, it will be instantly added to account with automatic verification.</p>
                      </div>
            </div>

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
                <div class="service-box orange">
                    <i class="bi bi-arrow-repeat icon"></i>
                    <h3>Lifetime Updates</h3>
                    <p>Enjoy free lifetime updates with the desired service.</p>
                        </div>
            </div>

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="400">
                <div class="service-box green">
                    <i class="bi bi-wallet icon"></i>
                    <h3>Unlimited Transactions</h3>
                    <p>Receive unlimited payments with PAY Online Bd without any fees.</p>
                     </div>
            </div>

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="500">
                <div class="service-box red">
                    <i class="bi bi-chat-dots icon"></i>
                    <h3>24/7 Support</h3>
                    <p>Our support team is available 24/7 to solve any issues, including PAY Online Bd setup and usage.</p>
                     </div>
            </div>

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="600">
                <div class="service-box purple">
                    <i class="bi bi-credit-card icon"></i>
                    <h3>Payment Processing</h3>
                    <p>Efficient and secure processing for all your payment needs, ensuring seamless transactions every time.</p>
                     </div>
            </div>

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="700">
                <div class="service-box pink">
                    <i class="bi bi-shield-check icon"></i>
                    <h3>Fraud Prevention</h3>
                    <p>Advanced fraud prevention measures to protect your business and customers from unauthorized activities.</p>
                      </div>
            </div>

        </div>

    </div>

</section><!-- End Services Section -->

</main>



    <!-- ======= Pricing Section ======= -->
    <section id="pricing" class="pricing">

        <div class="container" data-aos="fade-up">

            <header class="section-header">
                <h2>Pricing</h2>
                <p>Check our Pricing</p>
            </header>

            <div class="row gy-4" data-aos="fade-left">

                <?php if (!empty($plans)) : foreach ($plans as $plan) :  ?>
                        <div class="col-lg-3 col-md-6" data-aos="zoom-in" data-aos-delay="100">
                            <div class="box">
                                <h3 style="color: #07d5c0;"><?= $plan['name'] ?></h3>
                                <div class="price"><sup></sup><?= currency_format($plan['final_price']) ?><span> / <?= duration_type($plan['name'], $plan['duration_type'], $plan['duration'], false) ?></span></div>
                                <p class="text-center"><?= $plan['description'] ?></p>

                                <ul>
                                    
                                    <li><?= plan_message('brand', $plan['brand']) ?></li>
                                    <li><?= plan_message('device', $plan['device']) ?></li>
                                    <li><?= plan_message('transaction', $plan['transaction']) ?></li>
                                </ul>
                                <a href="<?= user_url('plans') ?>" class="btn-buy">Buy Now</a>
                            </div>
                        </div>
                <?php endforeach;
                endif; ?>



            </div>

        </div>

        </div>

    </section><!-- End Pricing Section -->
    
    <!-- ======= Platform Section ======= -->
    <section id="" class="clients">

      <div class="container" data-aos="fade-up">

        <header class="section-header">
          <p>Supported Platforms</p>
        </header>

        <div class="clients-slider swiper">
          <div class="swiper-wrapper align-items-center">
          <div class="swiper-slide"><img src="public/assets/plat/smm.png" class="img-fluid" alt=""></div>
            <div class="swiper-slide"><img src="public/assets/plat/php.png" class="img-fluid" alt=""></div>
            <div class="swiper-slide"><img src="public/assets/plat/javascript.png" class="img-fluid" alt=""></div>
            <div class="swiper-slide"><img src="public/assets/plat/jquery.png" class="img-fluid" alt=""></div>
            <div class="swiper-slide"><img src="public/assets/plat/nodejs.png" class="img-fluid" alt=""></div>
            <div class="swiper-slide"><img src="public/assets/plat/whmcs-logo.png" class="img-fluid" alt=""></div>
            <div class="swiper-slide"><img src="public/assets/plat/woocommerce-logo-transparent.png" class="img-fluid" alt=""></div>
            <div class="swiper-slide"><img src="public/assets/plat/wordpress-logo-stacked-rgb.png" class="img-fluid" alt=""></div>
          </div>
          <div class="swiper-pagination"></div>
        </div>
      </div>

    </section><!-- End Section -->
    
    
    <!-- ======= F.A.Q Section ======= -->
    <section id="faq" class="faq">

        <div class="container" data-aos="fade-up">

            <header class="section-header">
                <h2>F.A.Q</h2>
                <p>Frequently Asked Questions</p>
            </header>
            <?php if (!empty($items)) : ?>
                <div class="row">
                    <div class="col-lg-6">
                        <!-- F.A.Q List 1-->
                        <div class="accordion accordion-flush" id="faqlist1">
                            <?php
                            // Split items for the first column
                            $firstColumnItems = array_slice($items, 0, ceil(count($items) / 2));
                            foreach ($firstColumnItems as $key => $item) : ?>
                                <div class="accordion-item wow fadeInUp" data-wow-delay="0.1s">
                                    <h2 class="accordion-header" id="m<?= $item['id'] ?>">
                                        <button class="accordion-button <?= $key == 0 ? '' : 'collapsed' ?>" type="button" data-bs-toggle="collapse" data-bs-target="#kkk<?= $item['id'] ?>" aria-expanded="<?= $key == 0 ? 'true' : 'false' ?>" aria-controls="kkk<?= $item['id'] ?>">
                                            <?= $item['question'] ?>
                                        </button>
                                    </h2>
                                    <div id="kkk<?= $item['id'] ?>" class="accordion-collapse collapse <?= $key == 0 ? 'show' : '' ?>" aria-labelledby="m<?= $item['id'] ?>" data-bs-parent="#faqlist1">
                                        <div class="accordion-body">
                                            <?= $item['answer'] ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <!-- F.A.Q List 2-->
                        <div class="accordion accordion-flush" id="faqlist2">
                            <?php
                            // Split items for the second column
                            $secondColumnItems = array_slice($items, ceil(count($items) / 2));
                            foreach ($secondColumnItems as $key => $item) : ?>
                                <div class="accordion-item wow fadeInUp" data-wow-delay="0.1s">
                                    <h2 class="accordion-header" id="m<?= $item['id'] ?>">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#kkk<?= $item['id'] ?>" aria-expanded="false" aria-controls="kkk<?= $item['id'] ?>">
                                            <?= $item['question'] ?>
                                        </button>
                                    </h2>
                                    <div id="kkk<?= $item['id'] ?>" class="accordion-collapse collapse" aria-labelledby="m<?= $item['id'] ?>" data-bs-parent="#faqlist2">
                                        <div class="accordion-body">
                                            <?= $item['answer'] ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>


        </div>

    </section><!-- End F.A.Q Section -->

    <section id="clients" class="clients">

        <div class="container" data-aos="fade-up">

            <header class="section-header">
                <p>Supported Gateways</p>
            </header>

            <div class="clients-slider swiper">
                <div class="swiper-wrapper align-items-center">
                    <?php if (!empty($payments)) : foreach ($payments as $payment) : ?>
                            <div class="swiper-slide"><img src="<?= base_url() . @get_value(get_value($payment['params'], 'option'), 'logo'); ?>" class="img-fluid" alt=""></div>
                    <?php endforeach;
                    endif; ?>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>

    </section><!-- End Clients Section -->
    
<section id="contact" class="contact">

      <div class="container" data-aos="fade-up">

        <header class="section-header">
          <p>Contact US</p>
        </header>

        <div class="row gy-4">

          <div class="col-lg-6">

            <div class="row gy-4">
              <div class="col-md-6">
                <div class="info-box">
                  <i class="bi bi-geo-alt"></i>
                  <h3>Address</h3>
                  <p><?= site_config('address') ?></p>
                </div>
              </div>
              <div class="col-md-6">
                <div class="info-box">
                  <i class="bi bi-telephone"></i>
                  <h3>Call Us</h3>
                  <p><?= site_config('contact_tel') ?></p>
                </div>
              </div>
              <div class="col-md-6">
                <div class="info-box">
                  <i class="bi bi-envelope"></i>
                  <h3>Email Us</h3>
                  <p><?= site_config('contact_email') ?></p>
                </div>
              </div>
              <div class="col-md-6">
                <div class="info-box">
                  <i class="bi bi-clock"></i>
                  <h3>Open Hours</h3>
                  <p><?= site_config('contact_work_hour') ?></p>
                </div>
              </div>
            </div>

          </div>

          

        </div>

      </div>

   
