<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    /**
     * Display the main dashboard.
     */
    public function index()
    {
        return view('dashboard.index');
    }

    /**
     * Display the dashboard payment page.
     */
    public function payment()
    {
        return view('dashboard.payment');
    }

    public function brands()
    {
        return view('dashboard.brands');
    }

    public function affiliates()
    {
        $user = Auth::user();

        // If the user doesn't have a referral code, generate one.
        if (empty($user->referral_code)) {
            do {
                // Generate a unique referral code for the new user
                $newUserReferralCode = md5(uniqid(rand(), true));
            } while (User::where('referral_code', $newUserReferralCode)->exists());

            $user->referral_code = $newUserReferralCode;
            $user->save();
        }
        return view('dashboard.affiliates', compact('user'));
    }

    /**
     * Display the stored data page.
     */
    public function storedData(): \Illuminate\View\View
    {
        return view('dashboard.stored-data');
    }

}
