<?php
namespace App\Http\Controllers;

use App\Models\Brand;
use App\Models\User;
use App\Models\WalletSetting;
use Illuminate\Http\Request;

class FrontendController extends Controller
{
    public function home(){ return view('frontend.home'); }
    public function about(){ return view('frontend.about'); }
    public function contact(){ return view('frontend.contact'); }
    public function pricing(){ return view('frontend.pricing'); }
    public function paymentSuccess(Request $request)
    {
        return view('frontend.payment-success');
    }

    public function paymentFailed(Request $request)
    {
        return view('frontend.payment-failed');
    }

    public function payment(Request $request)
    {
        $brand_identifier = $request->query('brand_key'); // Keep this
        $amount = $request->query('amount', 0); // Keep this

        $transactionId = 'TXN' . strtoupper(uniqid());
        $brand = null;
        $activeWallets = collect();
        $error = null;        

        // Determine which brand's payment gateways to show.
        // First try to get the brand by ID as it's more specific
        $brandId = $request->query('brand_id');
        if ($brandId) {
            $brand = Brand::where('id', $brandId)
                         ->where('status', 1)
                         ->first();
            
            // If brand is found by ID, don't look further
            if ($brand) {
                $brand_identifier = $brand->brand_key;
            }
        }
        
        // If brand not found by ID, try brand_key
        if (!$brand && $brand_identifier) {
            $brand = Brand::where('brand_key', $brand_identifier)
                         ->where('status', 1)
                         ->first();
        }
        
        // No fallback to default brand - if specified brand not found, show error
        if (!$brand) {
            $error = 'The specified brand is invalid or inactive.';
        }

        if ($brand) { // A specific brand was found (either by ID or key)
            // Brand found, get its specific wallet settings.
            $activeWallets = WalletSetting::where('brand_id', $brand->id)
                ->where('status', 1)
                ->where(function ($query) {
                    $mobileWallets = ['bkash', 'nagad', 'rocket', 'upay', 'cellfin', 'tap', 'okwallet', 'surecash', 'mcash', 'mycash', 'ipay'];

                    // Condition 1: It's a mobile wallet and at least one of its types is active.
                    $query->where(function ($q1) use ($mobileWallets) {
                        $q1->whereIn('wallet_type', $mobileWallets)
                           ->where(function ($q2) {
                               $q2->where('is_personal_active', 1)
                                  ->orWhere('is_agent_active', 1)                                  
                                  // For merchant, also check if credentials exist
                                  ->orWhere(function ($q3) {
                                      $q3->where('is_merchant_active', 1)->whereNotNull('app_key')->whereNotNull('app_secret');
                                  })
                                  ->orWhere('is_payment_active', 1);
                           });
                    })
                    // Condition 2: OR it's not a mobile wallet (e.g., bank, crypto).
                    // The general `status = 1` check already covers these.
                    ->orWhereNotIn('wallet_type', $mobileWallets);
                })->latest()->get();

            if ($activeWallets->isEmpty()) {
                $error = 'No payment methods are currently active for this brand.';
            }
        } elseif ($brand_identifier) {
            // A brand key or ID was provided, but the brand was not found or is inactive.
            $error = 'The specified brand is invalid or inactive.';
        }  else {
            $error = 'No active payment brand is configured. Please contact support.';
        }

        return view('frontend.payment', compact('amount', 'activeWallets', 'brand', 'error', 'transactionId'));
    }
}
