<?php

namespace App\Http\Controllers;

use App\Models\Merchant;
use Illuminate\Http\Request;

class MerchantController extends Controller
{
    public function index()
    {
        $merchants = Merchant::paginate(15);
        return view('dashboard.merchants', compact('merchants'));
    }
    public function create()
    {
        return view('dashboard.merchants');
    }
    public function store(Request $r)
    {
        Merchant::create($r->validate(['name' => 'required', 'email' => 'required|email']));
        return redirect()->route('merchants.index');
    }
    public function show(Merchant $merchant)
    {
        return view('dashboard.merchants', compact('merchant'));
    }
    public function edit(Merchant $merchant)
    {
        return view('dashboard.merchants', compact('merchant'));
    }
    public function update(Request $r, Merchant $merchant)
    {
        $merchant->update($r->only('name', 'email'));
        return back();
    }
    public function destroy(Merchant $merchant)
    {
        $merchant->delete();
        return back();
    }
}
