<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Device;
use Jenssegers\Agent\Agent; // Make sure you've installed this package

class TrackUserDevice
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure
     * @return \Illuminate\Http\Response
     */
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check()) {
            $user = Auth::user();
            $sessionId = $request->session()->getId();
            $userAgentHeader = $request->header('User-Agent');
            $ipAddress = $request->ip();

            // Initialize Agent to get device details
            $agent = new Agent();
            $agent->setUserAgent($userAgentHeader);

            $deviceType = 'Unknown';
            if ($agent->isDesktop()) {
                $deviceType = 'Desktop';
            } elseif ($agent->isTablet()) {
                $deviceType = 'Tablet';
            } elseif ($agent->isMobile()) {
                $deviceType = 'Mobile';
            }

            // Try to find an existing device record for the same user agent and IP to avoid creating duplicates.
            // We prioritize matching an existing device over creating a new one for each session.
            $device = $user->devices()
                ->where('user_agent', $userAgentHeader)
                ->where('ip_address', $ipAddress)
                ->first();

            // If no matching device is found, create a new one.
            // This will happen on the first login from a new browser/device.
            if (!$device) {
                $device = new Device();
                $device->user_id = $user->id;
                $device->name = 'Unnamed Device';
                $device->device_type = $deviceType;
                $device->browser = $agent->browser();
                $device->user_agent = $userAgentHeader;
                $device->ip_address = $ipAddress;
            }

            $device->session_id = $sessionId; // Always ensure session_id is set/updated
            $device->last_activity = now();

            $device->save();
        }

        return $next($request);
    }
}
