<?php

namespace App\Listeners;

use App\Mail\PaymentSuccessMail;
use App\Models\Transaction;
use Ihasan\Bkash\Events\PaymentSuccessful;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class SendBkashPaymentNotification
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(PaymentSuccessful $event)
    {
        $payment = $event->payment; // This is the Ihasan\Bkash\Models\BkashPayment model instance.
        $paymentData = $event->paymentData; // This is the raw response array from bKash.

        Log::info('bKash PaymentSuccessful event received.', [
            'payment_id' => $payment->payment_id,
            'invoice_number' => $payment->merchant_invoice_number
        ]);

        // The 'merchant_invoice_number' from bKash corresponds to our 'system_trx_id'.
        $transaction = Transaction::where('system_trx_id', $payment->merchant_invoice_number)->first();

        if (!$transaction) {
            Log::error('No matching transaction found for bKash invoice: ' . $payment->merchant_invoice_number);
            return;
        }

        // Load the brand owner's user model to get their email.
        $transaction->load('brand.user');
        $brandOwner = $transaction->brand->user ?? null;

        // Send a success email to the brand owner.
        if ($brandOwner && $brandOwner->email) {
            Mail::to($brandOwner->email)->queue(new PaymentSuccessMail($transaction));
            Log::info('Queued successful payment email for transaction: ' . $transaction->id . ' to ' . $brandOwner->email);
        }
    }
}
