<?php

namespace App\Models;

use Ihasan\Bkash\Models\BkashTenant as BaseBkashTenant;

class BkashTenant extends BaseBkashTenant
{
    public static function getCredentials(string $tenantId): array
    {
        $walletSettings = WalletSetting::where('brand_id', $tenantId)
            ->where('wallet_type', 'bkash')
            ->where('is_merchant_active', 1)
            ->first();

        if (!$walletSettings) {
            throw new \Exception("bKash credentials not found for brand ID: {$tenantId}");
        }

        return [
            'app_key' => $walletSettings->app_key,
            'app_secret' => $walletSettings->app_secret,
            'username' => $walletSettings->username,
            'password' => $walletSettings->password,
        ];
    }
}