<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\User;

class Brand extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 'name', 'brand_key', 'mobile_number', 'domain', 'whatsapp_number',
        'support_mail', 'fees_type', 'fees', 'status', 'brand_logo',
    ];

    /**
     * The user who owns the brand.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
