<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_number',
        'amount',
        'brand_id',
        'due_date',
        'status',
        'payment_status',
        'customer_name',
        'customer_number',
        'customer_email',
        'customer_address',
        'description',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'due_date' => 'date',
        'status' => 'boolean',
    ];

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($invoice) {
            if (empty($invoice->invoice_number)) {
                $invoiceCount = static::count() + 1;
                $invoice->invoice_number = 'INV-' . date('Ymd') . '-' . str_pad($invoiceCount, 4, '0', STR_PAD_LEFT);
            }
        });
    }
}