<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Transaction extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'merchant_id',
        'brand_id',
        'system_trx_id',
        'trx_id',
        'payment_gateway',
        'amount',
        'currency',
        'status',
        'status_message'
    ];

    /**
     * Get the user that owns the transaction.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function brand(): BelongsTo {
        return $this->belongsTo(Brand::class);
    }
}
