<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WalletSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 'brand_id', 'wallet_type', 'status',
        'is_personal_active', 'personal_number',
        'is_agent_active', 'agent_number',
        'is_merchant_active', 'username', 'password', 'app_key', 'app_secret',
        'is_payment_active', 'payment_number',
        'sandbox', 'logs',
        'account_number', 'account_name', 'branch_name',
        'wallet_address', 'api_key',
    ];

    /**
     * Get the bKash credentials for a specific tenant (brand).
     * This method is required by the theihasan/laravel-bkash package.
     *
     * @param int|string $tenantId The ID of the brand.
     * @return array The credentials for bKash.
     * @throws \Exception If credentials are not found or incomplete.
     */
    public static function getCredentials(int|string $tenantId): array
    {
        $setting = self::where('brand_id', $tenantId)
            ->where('wallet_type', 'bkash')
            ->where('is_merchant_active', true)
            ->first();

        if (!$setting || !$setting->app_key || !$setting->app_secret) {
            throw new \Exception("bKash merchant credentials not found or are incomplete for Brand ID: {$tenantId}.");
        }

        return $setting->only(['app_key', 'app_secret', 'username', 'password']);
    }
}