<?php

namespace App\Providers;
use Illuminate\Support\Facades\Auth;

use Illuminate\Support\ServiceProvider;
use App\Services\Payment\BkashPaymentService;
use App\Services\Payment\NagadPaymentService;
use App\Services\Payment\RocketPaymentService;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        if (!$this->app->runningInConsole()) {
            $this->app->register(\Ihasan\Bkash\BkashServiceProvider::class);
        }

    $this->app->singleton(BkashPaymentService::class);
    $this->app->singleton(NagadPaymentService::class);
    $this->app->singleton(RocketPaymentService::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        \Illuminate\Support\Facades\Redirect::macro('dashboard', function () {
            if (Auth::check()) {
                $role = Auth::user()->role;
                return redirect()->route($role . '.dashboard');
            }
            return redirect('/');
        });
    }
}