<?php

namespace App\Services\Payment;

class NagadPaymentService
{
    private $merchantID;
    private $merchantKey;
    private $publicKey;
    private $baseUrl;

    public function __construct()
    {
        $this->merchantID = config('services.nagad.merchant_id');
        $this->merchantKey = config('services.nagad.merchant_key');
        $this->publicKey = config('services.nagad.public_key');
        $this->baseUrl = config('services.nagad.base_url');
    }

    private function generateSignature($data)
    {
        $signature = hash_hmac('sha256', json_encode($data), $this->merchantKey);
        return $signature;
    }

    public function initiatePayment($amount, $invoice)
    {
        $datetime = date('YmdHis');
        $random = rand(10000000, 99999999);
        $orderId = $datetime . $random;

        $sensitiveData = [
            'merchantId' => $this->merchantID,
            'orderId' => $orderId,
            'datetime' => $datetime,
            'challenge' => $random
        ];

        // Encrypt sensitive data
        $publicKey = openssl_pkey_get_public($this->publicKey);
        openssl_public_encrypt(json_encode($sensitiveData), $encryptedData, $publicKey);
        $sensitiveDataEncoded = base64_encode($encryptedData);

        $postData = [
            'dateTime' => $datetime,
            'sensitiveData' => $sensitiveDataEncoded,
            'signature' => $this->generateSignature($sensitiveData),
            'merchantId' => $this->merchantID,
            'orderId' => $orderId,
            'amount' => $amount,
            'currencyCode' => 'BDT',
            'challenge' => $random
        ];

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $this->baseUrl . '/api/dfs/check-out/initialize');
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        
        $response = curl_exec($curl);
        curl_close($curl);
        
        return json_decode($response, true);
    }

    public function verifyPayment($paymentRefId)
    {
        $datetime = date('YmdHis');
        
        $sensitiveData = [
            'merchantId' => $this->merchantID,
            'orderId' => $paymentRefId,
            'datetime' => $datetime,
        ];

        $postData = [
            'dateTime' => $datetime,
            'sensitiveData' => base64_encode(json_encode($sensitiveData)),
            'signature' => $this->generateSignature($sensitiveData),
            'merchantId' => $this->merchantID,
            'orderId' => $paymentRefId,
        ];

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $this->baseUrl . '/api/dfs/verify/payment');
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        
        $response = curl_exec($curl);
        curl_close($curl);
        
        return json_decode($response, true);
    }
}