<?php

namespace App\Services\Payment;

class RocketPaymentService
{
    private $merchantNumber;

    public function __construct()
    {
        $this->merchantNumber = config('services.rocket.merchant_number');
    }

    public function getAccountNumber()
    {
        return $this->merchantNumber;
    }

    public function verifyTransaction($trxId, $amount)
    {
        // For manual verification, you might want to implement additional checks here
        // such as checking against your database of expected transactions
        
        // Basic validation for Rocket transaction ID format
        if (!preg_match('/^[A-Za-z0-9]{8,}$/', $trxId)) {
            return [
                'success' => false,
                'message' => 'Invalid transaction ID format'
            ];
        }

        // Here you would typically verify the transaction with your own business logic
        // For example, checking if the transaction ID exists in your database
        // and if the amount matches what was expected

        return [
            'success' => true,
            'message' => 'Transaction verified successfully',
            'data' => [
                'trx_id' => $trxId,
                'amount' => $amount,
                'status' => 'success'
            ]
        ];
    }
}