<?php

return [
    'sandbox' => env('BKASH_SANDBOX', true),
    
    'tenant_class' => \App\Models\WalletSetting::class,

    'sandbox_base_url' => env('BKASH_SANDBOX_BASE_URL', 'https://tokenized.sandbox.bka.sh/tokenized/checkout'),
    'live_base_url'    => env('BKASH_LIVE_BASE_URL', 'https://tokenized.pay.bka.sh/tokenized/checkout'),

    'version' => env('BKASH_VERSION', 'v1.2.0-beta'),
    'default_currency' => 'BDT',
    'default_intent' => 'sale',

    'cache' => [
        'token_lifetime' => 3500, // 58 minutes, bKash token expires in 60 minutes
    ],

    'redirect_urls' => [
        'success' => '/payment-success',
        'failed' => '/payment-failed',
    ],

    'timeout' => 60,

    'events' => [
        'payment_success' => env('BKASH_FIRE_PAYMENT_SUCCESS_EVENT', true),
    ],

    'database' => [
        'table_prefix' => env('BKASH_TABLE_PREFIX', 'bkash_'),
    ],
];