<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('brands', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('name')->unique();
            $table->string('brand_key', 60)->unique();
            $table->string('mobile_number', 20)->nullable();
            $table->string('domain')->nullable();
            $table->string('whatsapp_number', 20)->nullable();
            $table->string('support_mail')->nullable();
            $table->boolean('fees_type')->comment('0: Flat, 1: Percent');
            $table->decimal('fees', 10, 2);
            $table->boolean('status')->default(true);
            $table->string('brand_logo')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('brands');
    }
};
