<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wallet_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('brand_id')->nullable()->constrained()->onDelete('cascade');
            $table->string('wallet_type');
            $table->boolean('status')->default(false);

            // Mobile Banking fields
            $table->boolean('is_personal_active')->nullable();
            $table->boolean('is_agent_active')->nullable();
            $table->boolean('is_merchant_active')->nullable();
            $table->boolean('is_payment_active')->nullable();
            $table->string('personal_number')->nullable();
            $table->string('payment_number')->nullable();
            $table->string('agent_number')->nullable();
            $table->boolean('sandbox')->nullable();
            $table->boolean('logs')->nullable();
            $table->string('username')->nullable();
            $table->string('password')->nullable();
            $table->string('app_key')->nullable();
            $table->string('app_secret')->nullable();

            // Bank fields
            $table->string('account_number')->nullable();
            $table->string('account_name')->nullable();
            $table->string('branch_name')->nullable();

            // Crypto fields
            $table->string('wallet_address')->nullable();
            $table->string('api_key')->nullable();

            $table->timestamps();

            $table->unique(['user_id', 'wallet_type', 'brand_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallet_settings');
    }
};
