<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->foreignId('user_id')
                  ->nullable()
                  ->after('id') // Places the column after the 'id' column
                  ->constrained('users')
                  ->onDelete('set null'); // If a user is deleted, set user_id to null
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // To drop the column, we must first drop the foreign key constraint
            $table->dropForeign(['user_id']);
            $table->dropColumn('user_id');
        });
    }
};
