<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Add brand_id foreign key
            $table->foreignId('brand_id')->nullable()->after('merchant_id')->constrained('brands')->onDelete('set null');

            // Add system_trx_id
            $table->string('system_trx_id')->nullable()->after('brand_id');

            // Make merchant_id nullable
            $table->foreignId('merchant_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropForeign(['brand_id']);
            $table->dropColumn(['brand_id', 'system_trx_id']);
            $table->foreignId('merchant_id')->nullable(false)->change();
        });
    }
};
