<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_number')->unique();
            $table->decimal('amount', 10, 2);
            $table->foreignId('brand_id')->constrained()->onDelete('cascade');
            $table->date('due_date');
            $table->boolean('status')->default(true);
            $table->enum('payment_status', ['unpaid', 'pending', 'paid'])->default('unpaid');
            $table->string('customer_name');
            $table->string('customer_number')->nullable();
            $table->string('customer_email')->nullable();
            $table->text('customer_address')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('invoices');
    }
};