document.addEventListener('DOMContentLoaded', function () {
    const tabs = document.querySelectorAll('.nav-tab');
    const panels = document.querySelectorAll('.tab-panel');
    const paymentMethods = document.querySelectorAll('.payment-method');
    const payButton = document.querySelector('.pay-button');
    const closeBtn = document.querySelector('.close-btn');
    const container = document.querySelector('.payment-container');

    let selectedMethod = null;

    // Tab Switching
    tabs.forEach(tab => {
        tab.addEventListener('click', function () {
            const target = this.dataset.tab;

            tabs.forEach(t => t.classList.remove('active', 'bg-white', 'text-primary', 'shadow'));
            panels.forEach(p => p.classList.add('hidden'));

            this.classList.add('active', 'bg-white', 'text-primary', 'shadow');
            document.getElementById(`${target}-panel`).classList.remove('hidden');
        });
    });

    // Payment Method Selection
    paymentMethods.forEach(method => {
        method.addEventListener('click', function () {
            paymentMethods.forEach(m => m.classList.remove('selected', 'border-primary', 'bg-primary-light'));
            this.classList.add('selected', 'border-primary', 'bg-primary-light');
            selectedMethod = this.dataset.method;

            const methodName = this.querySelector('.font-semibold').textContent;
            payButton.innerHTML = `<i class="fas fa-lock"></i> Pay with ${methodName}`;
        });
    });

    // Close Button
    closeBtn.addEventListener('click', function () {
        container.style.animation = 'fadeOut 0.3s ease-in forwards';
        setTimeout(() => {
            alert('Payment cancelled. You will be redirected back.');
            // In a real app, you would redirect here, e.g., window.location.href = '/cancel-url';
        }, 300);
    });

    // Pay Button
    payButton.addEventListener('click', function () {
        if (!selectedMethod) {
            alert('Please select a payment method first.');
            return;
        }

        this.innerHTML = `<i class="fas fa-spinner fa-spin"></i> Processing...`;
        this.disabled = true;

        setTimeout(() => {
            alert('Payment successful! Thank you for your purchase.');
            // In a real app, you would redirect to a success page here.
        }, 2000);
    });
});
