@extends('layouts.guest')

@section('title', 'Forgot Password - HilnexPay')

@push('styles')
<style>
    .form-container {
        background-color: #ffffff;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        padding: 2.5rem;
        width: 100%;
        max-width: 420px;
    }
    .form-input {
        border: 1px solid #ddd;
        border-radius: 6px;
        padding: 0.75rem 1rem;
        width: 100%;
        transition: border-color 0.2s, box-shadow 0.2s;
    }
    .form-input:focus {
        border-color: #4f46e5;
        box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.2);
        outline: none;
    }
    .btn-primary-action {
        background-color: #4f46e5; /* indigo-600 */
        color: white;
        font-weight: bold;
        padding: 0.75rem;
        border-radius: 6px;
        width: 100%;
        transition: background-color 0.3s;
    }
    .btn-primary-action:hover {
        background-color: #4338ca; /* indigo-700 */
    }
</style>
@endpush

@section('content')
<div class="form-container">
    <div class="text-center mb-8">
        <a href="{{ url('/') }}">
            <img src="{{ asset('assets/image/hilnex-logo1.png') }}" alt="HilnexPay Logo" class="h-12 mx-auto mb-4">
        </a>
        <h2 class="text-2xl font-bold text-gray-900">Forgot Password?</h2>
        <p class="text-gray-600 mt-2 text-sm">{{ __('No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.') }}</p>
    </div>

    <!-- Session Status -->
    <x-auth-session-status class="mb-4" :status="session('status')" />

    <form method="POST" action="{{ route('password.email') }}" class="space-y-6">
        @csrf
        <input type="email" name="email" placeholder="Email address" class="form-input" value="{{ old('email') }}" required autofocus>
        <x-input-error :messages="$errors->get('email')" class="mt-2" />
        <button type="submit" class="btn-primary-action">{{ __('Email Password Reset Link') }}</button>
    </form>
</div>
@endsection
