@extends('layouts.guest')

@section('title', 'Login - HilnexPay')

@section('content')
<div class="w-full max-w-sm">
    <div class="text-center mb-8">
        <a href="{{ url('/') }}">
            <img src="{{ asset('assets/image/hilnex-logo1.png') }}" alt="HilnexPay Logo" class="h-12 mx-auto lg:hidden mb-4">
        </a>
        <h2 class="text-2xl font-bold text-gray-900">Welcome Back!</h2>
        <p class="text-gray-600">Log in to continue.</p>
    </div>
    <form method="POST" action="{{ route('login') }}" class="space-y-5">
        @csrf
        <!-- Email Address -->
        <div class="relative">
            <i class="fas fa-envelope form-input-icon"></i>
            <input id="email" type="email" name="email" placeholder="Email address" class="form-input form-input-with-icon" value="{{ old('email') }}" required autofocus autocomplete="email">
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <!-- Password -->
        <div class="relative" x-data="{ show: false }">
            <i class="fas fa-lock form-input-icon"></i>
            <input id="password" :type="show ? 'text' : 'password'" name="password" placeholder="Password" class="form-input form-input-with-icon" required autocomplete="current-password">
            <div class="absolute inset-y-0 right-0 pr-3 flex items-center text-sm leading-5">
                <i class="fas password-toggle text-gray-400" :class="{'fa-eye-slash': !show, 'fa-eye': show }" @click="show = !show"></i>
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Remember Me & Forgot Password -->
        <div class="flex items-center justify-between">
            <label for="remember_me" class="inline-flex items-center">
                <input id="remember_me" type="checkbox" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" name="remember">
                <span class="ml-2 text-sm text-gray-600">{{ __('Remember me') }}</span>
            </label>

            @if (Route::has('password.request'))
                <a class="text-sm text-indigo-600 hover:underline" href="{{ route('password.request') }}">
                    {{ __('Forgot password?') }}
                </a>
            @endif
        </div>

        <!-- Login Button -->
        <div class="pt-2">
            <button type="submit" class="btn-primary-login">Log In</button>
        </div>

        <div class="relative flex py-2 items-center">
            <div class="flex-grow border-t border-gray-300"></div>
            <span class="flex-shrink mx-4 text-gray-500 text-sm">OR</span>
            <div class="flex-grow border-t border-gray-300"></div>
        </div>

        <div class="text-center"><a href="{{ route('register') }}" class="btn-secondary-register inline-block w-full">Create new account</a></div>
    </form>
</div>
@endsection
