@extends('layouts.guest')

@section('title', 'Register - HilnexPay')

@section('content')
<div class="w-full max-w-sm">
    <div class="text-center mb-8">
        <a href="{{ url('/') }}">
            <img src="{{ asset('assets/image/hilnex-logo1.png') }}" alt="HilnexPay Logo" class="h-12 mx-auto mb-4">
        </a>
        <h2 class="text-2xl font-bold text-gray-900">Create a new account</h2>
        <p class="text-gray-600">It's quick and easy.</p>
    </div>

    <form method="POST" action="{{ route('register') }}" class="space-y-4">
        @csrf

        <!-- Name -->
        <div>
            <input id="name" type="text" name="name" placeholder="Full Name" class="form-input" value="{{ old('name') }}" required autofocus autocomplete="name">
            <x-input-error :messages="$errors->get('name')" class="mt-2" />
        </div>

        <!-- Email Address -->
        <div>
            <input id="email" type="email" name="email" placeholder="Email address" class="form-input" value="{{ old('email') }}" required autocomplete="username">
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <!-- Password -->
        <div>
            <input id="password" type="password" name="password" placeholder="New password" class="form-input" required autocomplete="new-password">
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Confirm Password -->
        <div>
            <input id="password_confirmation" type="password" name="password_confirmation" placeholder="Confirm password" class="form-input" required autocomplete="new-password">
            <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
        </div>

        <div class="pt-4">
            <button type="submit" class="btn-primary-register">Sign Up</button>
        </div>

        <div class="text-center pt-2"><a href="{{ route('login') }}" class="text-sm text-indigo-600 hover:underline">Already have an account?</a></div>
    </form>
</div>
@endsection
