@php
    $prefix = auth()->user() && auth()->user()->role === 'admin' ? 'admin.' : 'user.';
    $user = auth()->user();
    if ($user) {
        if ($user->role === 'admin') {
            $brands = \App\Models\Brand::where('status', 1)->get();
        } else {
            $brands = \App\Models\Brand::where('user_id', $user->id)->where('status', 1)->get();
        }
    } else {
        $brands = collect();
    }
    $defaultBrandId = $brands->first()?->id;
@endphp

<x-modal name="add-funds-modal" focusable>
    <form method="POST" action="{{ route($prefix . 'funds.store') }}" class="p-6">
        @csrf

        <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
            <i class="fas fa-money-bill-wave mr-2"></i>
            {{ __('Add Funds to Your Account') }}
        </h2>
        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
            Choose an amount and a payment method to proceed.
        </p>

        @if ($errors->any())
            <div class="mt-6 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                <strong class="font-bold">Oops!</strong>
                <span class="block sm:inline">There were some problems with your input.</span>
                <ul class="mt-2 list-disc list-inside">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="mt-6 space-y-6">
            <!-- Brand Selector -->
            @if($brands->count() > 0)
            <div>
                <x-input-label for="brand_id" value="{{ __('Select Brand') }}" />
                <select name="brand_id" id="brand_id" required
                        class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                    @foreach($brands as $brand)
                        <option value="{{ $brand->id }}" {{ old('brand_id') == $brand->id ? 'selected' : '' }}>{{ $brand->name }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('brand_id')" class="mt-2" />
            </div>
            @endif

            <!-- Amount Input -->
            <div>
                <x-input-label for="amount" value="{{ __('Amount (BDT)') }}" />
                <div class="relative mt-1">
                    <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                        <span class="text-gray-500 sm:text-sm">৳</span>
                    </div>
                    <x-text-input type="number" name="amount" id="amount" step="0.01" min="1" required
                           class="block w-full pl-7 pr-12"
                           placeholder="0.00" :value="old('amount')" />
                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center pr-3">
                        <span class="text-gray-500 sm:text-sm">BDT</span>
                    </div>
                </div>
                <x-input-error :messages="$errors->get('amount')" class="mt-2" />
            </div>

            <!-- Terms and Conditions -->
            <div>
                <label for="terms" class="flex items-center">
                    <input id="terms" type="checkbox" name="terms" required
                           class="h-4 w-4 rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500">
                    <span class="ml-2 text-sm text-gray-600 dark:text-gray-400">I agree to the <a href="#" class="text-indigo-600 hover:underline">terms and conditions</a>.</span>
                </label>
                <x-input-error :messages="$errors->get('terms')" class="mt-2" />
            </div>
        </div>

        <div class="mt-6 flex justify-end">
            <x-secondary-button x-on:click="$dispatch('close')">
                {{ __('Cancel') }}
            </x-secondary-button>
            <x-primary-button class="ml-3">
                <i class="fas fa-arrow-right mr-2"></i>
                {{ __('Proceed to Payment') }}
            </x-primary-button>
        </div>
    </form>
</x-modal>
