@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')
    <div class="p-4 sm:p-6">
        <!-- Dashboard Cards -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
            <!-- Balance Card -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400">Balance</h3>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1">$18,500.00</p>
                    <p class="text-xs text-green-500 mt-1">↑ 5.2% from last month</p>
                </div>
                <div class="bg-indigo-100 dark:bg-indigo-900/50 text-indigo-600 dark:text-indigo-300 rounded-full p-3">
                    <i class="fas fa-wallet fa-lg"></i>
                </div>
            </div>

            <!-- Successful Transaction -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400">Successful Transactions</h3>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1">1,250</p>
                    <p class="text-xs text-green-500 mt-1">↑ 10.3% from last month</p>
                </div>
                <div class="bg-green-100 dark:bg-green-900/50 text-green-600 dark:text-green-300 rounded-full p-3">
                    <i class="fas fa-check-circle fa-lg"></i>
                </div>
            </div>

            <!-- Pending Transaction -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400">Pending Transactions</h3>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1">32</p>
                    <p class="text-xs text-red-500 mt-1">↓ 2.1% from last month</p>
                </div>
                <div class="bg-yellow-100 dark:bg-yellow-900/50 text-yellow-600 dark:text-yellow-300 rounded-full p-3">
                    <i class="fas fa-hourglass-half fa-lg"></i>
                </div>
            </div>

            <!-- Total Payments -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400">Total Payments</h3>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1">1,282</p>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">All time</p>
                </div>
                <div class="bg-purple-100 dark:bg-purple-900/50 text-purple-600 dark:text-purple-300 rounded-full p-3">
                    <i class="fas fa-credit-card fa-lg"></i>
                </div>
            </div>
        </div>

        <!-- Transactions Section -->
        <div class="mt-8 bg-white dark:bg-gray-800 rounded-lg shadow-md">
            <div class="p-6 flex justify-between items-center border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-gray-100">Recent Transactions</h2>
                <a href="#" class="text-sm font-medium text-indigo-600 dark:text-indigo-400 hover:underline">View All</a>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400 bg-white">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                        <tr>
                            <th scope="col" class="px-6 py-3">Transaction ID</th>
                            <th scope="col" class="px-6 py-3">Date</th>
                            <th scope="col" class="px-6 py-3">Amount</th>
                            <th scope="col" class="px-6 py-3">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                            <td class="px-6 py-4 font-medium text-gray-900 dark:text-white">#TXN12345</td>
                            <td class="px-6 py-4">2023-10-27</td>
                            <td class="px-6 py-4">$250.00</td>
                            <td class="px-6 py-4"><span class="bg-green-100 text-green-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded dark:bg-green-900 dark:text-green-300">Completed</span></td>
                        </tr>
                        <tr class="bg-white dark:bg-gray-800 hover:bg-gray-50 dark:hover:bg-gray-600">
                            <td class="px-6 py-4 font-medium text-gray-900 dark:text-white">#TXN12346</td>
                            <td class="px-6 py-4">2023-10-26</td>
                            <td class="px-6 py-4">$150.75</td>
                            <td class="px-6 py-4"><span class="bg-yellow-100 text-yellow-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded dark:bg-yellow-900 dark:text-yellow-300">Pending</span></td>
                        </tr>
                        <!-- Add more rows as needed -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // Add more JS as per project needs for Hinnexpay
    </script>
@endpush
