<!-- Backdrop for mobile -->
@php
    $prefix = auth()->check() && auth()->user()->role === 'admin' ? 'admin.' : (auth()->check() ? 'user.' : '');
@endphp

<div x-show="isSidebarOpen" @click="toggleSidebar" class="fixed inset-0 bg-black opacity-50 z-30 md:hidden" x-cloak></div>

<aside id="sidebar" class="fixed left-0 top-0 h-full bg-white dark:bg-gray-800 text-gray-800 dark:text-white transform transition-all duration-300 ease-in-out z-40 border-r border-gray-200 dark:border-gray-700
       flex flex-col" :class="isSidebarOpen ? 'translate-x-0 w-64' : '-translate-x-full md:translate-x-0 md:w-20'">
    <!-- Logo -->
    <div class="flex items-center justify-center h-16 overflow-hidden border-b border-gray-200 dark:border-gray-700">
        <a href="{{ url('/') }}">
            <!-- Full logo -->
            <img x-show="isSidebarOpen" src="{{ asset('assets/image/hilnex-logo1.png') }}" alt="Logo" class="h-10 w-auto transition-opacity duration-300">
            <!--Fav Icon logo -->
            <img x-show="!isSidebarOpen" src="{{ asset('assets/image/Fav-Icon-black.png') }}" alt="Logo Icon" class="h-10 w-10 transition-opacity duration-300">
        </a>
    </div>

    <!-- Navigation -->
    <nav class="mt-4 flex-grow overflow-y-auto text-gray-600 dark:text-gray-300" x-data="{ openTransactions: false, openInvoice: false, openData: false, openWallet: false }" :class="isSidebarOpen ? '' : 'overflow-hidden'">
        <a href="{{ auth()->check() ? (auth()->user()->role === 'admin' ? route('admin.dashboard') : route('user.dashboard')) : route('login') }}" class="flex items-center px-6 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white {{ request()->routeIs('user.dashboard') || request()->routeIs('admin.dashboard') ? 'bg-gray-100 dark:bg-gray-900 text-gray-900 dark:text-white' : '' }}" :class="isSidebarOpen ? '' : 'justify-center'">
            <i class="fas fa-home w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i>
            <span x-show="isSidebarOpen">Dashboard</span>
        </a>
        <button x-on:click.prevent="$dispatch('open-modal', 'add-funds-modal')"
            class="w-full flex items-center px-6 py-3 text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white"
            :class="isSidebarOpen ? '' : 'justify-center'">
            <i class="fas fa-plus-circle w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i>
            <span x-show="isSidebarOpen">Add Funds</span>
        </button>

        <!-- Transactions Dropdown -->
        <div class="relative" x-data="{ open: false }" @mouseenter="if (!isSidebarOpen) { open = true }" @mouseleave="if (!isSidebarOpen) { open = false }" @click.away="if (!isSidebarOpen) { open = false }">
            <div @click="if (isSidebarOpen) openTransactions = !openTransactions" class="flex items-center justify-between px-6 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white cursor-pointer" :class="isSidebarOpen ? '' : 'justify-center'">
                <div class="flex items-center" :class="isSidebarOpen ? '' : 'w-full justify-center'">
                    <i class="fas fa-exchange-alt w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i>
                    <span x-show="isSidebarOpen">Transactions</span>
                </div>
                <i x-show="isSidebarOpen" class="fas" :class="openTransactions ? 'fa-chevron-down' : 'fa-chevron-right'"></i>
            </div>
            <!-- Expanded sidebar dropdown -->
            <ul x-show="isSidebarOpen && openTransactions" x-transition class="bg-gray-50 dark:bg-gray-700/50">
                <li><a href="{{ route($prefix . 'transactions.index') }}" class="flex items-center py-2 px-12 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white"><i class="fas fa-list-alt mr-2"></i> All Transactions</a></li>
                <li><a href="#" class="flex items-center py-2 px-12 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white"><i class="fas fa-university mr-2"></i> Bank Transactions</a></li>
            </ul>
            <!-- Collapsed sidebar dropdown -->
            <ul x-show="!isSidebarOpen && open"
                class="absolute left-full top-0 w-48 bg-white dark:bg-gray-800 rounded-md shadow-lg py-1 z-50 ml-2">
                <li><a href="{{ route($prefix . 'transactions.index') }}" class="flex items-center py-2 px-4 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">All Transactions</a></li>
                <li><a href="#" class="flex items-center py-2 px-4 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Bank Transactions</a></li>
            </ul>
        </div>

        <!-- Invoice Dropdown -->
        <div class="relative" x-data="{ open: false }" @mouseenter="if (!isSidebarOpen) { open = true }" @mouseleave="if (!isSidebarOpen) { open = false }" @click.away="if (!isSidebarOpen) { open = false }">
            <div @click="if (isSidebarOpen) openInvoice = !openInvoice" class="flex items-center justify-between px-6 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white cursor-pointer" :class="isSidebarOpen ? '' : 'justify-center'">
                <div class="flex items-center" :class="isSidebarOpen ? '' : 'w-full justify-center'">
                    <i class="fas fa-file-invoice w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i> 
                    <span x-show="isSidebarOpen">Invoice</span>
                </div>
                <i x-show="isSidebarOpen" class="fas" :class="openInvoice ? 'fa-chevron-down' : 'fa-chevron-right'"></i>
            </div>
            <ul x-show="isSidebarOpen && openInvoice" x-transition class="bg-gray-50 dark:bg-gray-700/50">
                <li><a href="{{ route($prefix . 'invoices.index') }}" class="flex items-center py-2 px-12 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white"><i class="fas fa-list-alt mr-2"></i> Invoices</a></li>
                <li><a href="{{ route($prefix . 'invoices.create') }}" class="flex items-center py-2 px-12 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white"><i class="fas fa-plus mr-2"></i> Add Invoice</a></li>
            </ul>
            <ul x-show="!isSidebarOpen && open" class="absolute left-full top-0 w-48 bg-white dark:bg-gray-800 rounded-md shadow-lg py-1 z-50 ml-2">
                <li><a href="{{ route($prefix . 'invoices.index') }}" class="flex items-center py-2 px-4 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Invoices</a></li>
                <li><a href="{{ route($prefix . 'invoices.create') }}" class="flex items-center py-2 px-4 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Add Invoice</a></li>
            </ul>
        </div>

        <!-- Data Dropdown -->
        <div class="relative" x-data="{ open: false }" @mouseenter="if (!isSidebarOpen) { open = true }" @mouseleave="if (!isSidebarOpen) { open = false }" @click.away="if (!isSidebarOpen) { open = false }">
            <div @click="if (isSidebarOpen) openData = !openData" class="flex items-center justify-between px-6 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white cursor-pointer" :class="isSidebarOpen ? '' : 'justify-center'">
                <div class="flex items-center" :class="isSidebarOpen ? '' : 'w-full justify-center'">
                    <i class="fas fa-database w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i>
                    <span x-show="isSidebarOpen">Data</span>
                </div>
                <i x-show="isSidebarOpen" class="fas" :class="openData ? 'fa-chevron-down' : 'fa-chevron-right'"></i>
            </div>
            <ul x-show="isSidebarOpen && openData" x-transition class="bg-gray-50 dark:bg-gray-700/50">
                <li><a href="{{ route($prefix . 'stored-data') }}" class="flex items-center py-2 px-12 hover:text-gray-900 dark:hover:text-white {{ request()->routeIs($prefix . 'stored-data') ? 'text-gray-900 dark:text-white' : 'text-gray-600 dark:text-gray-400' }}"><i class="fas fa-archive mr-2"></i> Stored Data</a></li>
                <li><a href="#" class="flex items-center py-2 px-12 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white"><i class="fas fa-plus mr-2"></i> Add Data</a></li>
            </ul>
            <ul x-show="!isSidebarOpen && open"
                x-transition:enter="transition ease-out duration-200"
                x-transition:enter-start="opacity-0 -translate-x-2"
                x-transition:enter-end="opacity-100 translate-x-0"
                x-transition:leave="transition ease-in duration-150"
                x-transition:leave-start="opacity-100 translate-x-0"
                x-transition:leave-end="opacity-0 -translate-x-2"
                class="absolute left-full top-0 w-48 bg-white dark:bg-gray-800 rounded-md shadow-lg py-1 z-50 ml-2">
                <li><a href="{{ route($prefix . 'stored-data') }}" class="flex items-center py-2 px-4 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Stored Data</a></li>
                <li><a href="#" class="flex items-center py-2 px-4 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Add Data</a></li>
            </ul>
        </div>

        <!-- Wallet Dropdown -->
        <div class="relative" x-data="{ open: false }" @mouseenter="if (!isSidebarOpen) { open = true }" @mouseleave="if (!isSidebarOpen) { open = false }" @click.away="if (!isSidebarOpen) { open = false }">
            <div @click="if (isSidebarOpen) openWallet = !openWallet" class="flex items-center justify-between px-6 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white cursor-pointer {{ request()->routeIs('wallets.*') ? 'bg-gray-100 dark:bg-gray-900 text-gray-900 dark:text-white' : '' }}" :class="isSidebarOpen ? '' : 'justify-center'">
                <div class="flex items-center" :class="isSidebarOpen ? '' : 'w-full justify-center'">
                    <i class="fa-solid fa-gear w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i>
                    <span x-show="isSidebarOpen">Settings</span>
                </div>
                <i x-show="isSidebarOpen" class="fas" :class="openWallet ? 'fa-chevron-down' : 'fa-chevron-right'"></i>
            </div>
            <ul x-show="isSidebarOpen && openWallet" x-transition class="bg-gray-50 dark:bg-gray-700/50">
                <li><a href="{{ route($prefix . 'brands.index') }}" class="flex items-center py-2 px-12 hover:text-gray-900 dark:hover:text-white {{ request()->routeIs($prefix . 'brands.index') ? 'text-gray-900 dark:text-white' : 'text-gray-600 dark:text-gray-400' }}"><i class="fas fa-tags mr-2"></i> Brands</a></li>
                <li><a href="{{ route($prefix . 'devices') }}" class="flex items-center py-2 px-12 hover:text-gray-900 dark:hover:text-white {{ request()->routeIs($prefix . 'devices') ? 'text-gray-900 dark:text-white' : 'text-gray-600 dark:text-gray-400' }}"><i class="fas fa-mobile-alt mr-2"></i> Devices</a></li>

                <li><a href="{{ route($prefix . 'wallets') }}" class="flex items-center py-2 px-12 hover:text-gray-900 dark:hover:text-white {{ request()->routeIs($prefix . 'wallets') ? 'text-gray-900 dark:text-white' : 'text-gray-600 dark:text-gray-400' }}"><i class="fas fa-wallet mr-2"></i> Wallets</a></li>
            </ul>
            <ul x-show="!isSidebarOpen && open" x-cloak
                x-transition:enter="transition ease-out duration-200"
                x-transition:enter-start="opacity-0 -translate-x-2"
                x-transition:enter-end="opacity-100 translate-x-0"
                x-transition:leave="transition ease-in duration-150"
                x-transition:leave-start="opacity-100 translate-x-0"
                x-transition:leave-end="opacity-0 -translate-x-2"
                class="absolute left-full top-0 w-48 bg-white dark:bg-gray-800 rounded-md shadow-lg py-1 z-50 ml-2">
                <li><a href="{{ route($prefix . 'brands.index') }}" class="flex items-center py-2 px-4 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Brands</a></li>
                <li><a href="{{ route($prefix . 'devices') }}" class="flex items-center py-2 px-4 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Devices</a></li>
                <li><a href="{{ route($prefix . 'wallets') }}" class="flex items-center py-2 px-4 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Wallets</a></li>
            </ul>
        </div>

        <div class="px-6 py-3 font-bold text-gray-400 dark:text-gray-500 text-xs uppercase" :class="isSidebarOpen ? '' : 'text-center'"> <span x-show="isSidebarOpen">Others</span> <span x-show="!isSidebarOpen" class="hidden md:inline">-</span></div>

        <a href="{{ route($prefix . 'affiliates') }}" class="flex items-center px-6 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white {{ request()->routeIs($prefix . 'affiliates') ? 'bg-gray-100 dark:bg-gray-900 text-gray-900 dark:text-white' : '' }}" :class="isSidebarOpen ? '' : 'justify-center'">
            <i class="fas fa-users w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i>
            <span x-show="isSidebarOpen">Affiliates</span>
        </a>
        <a href="#" class="flex items-center px-6 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white" :class="isSidebarOpen ? '' : 'justify-center'">
            <i class="fas fa-box w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i>
            <span x-show="isSidebarOpen">Plans</span>
        </a>
        <a href="#" class="flex items-center px-6 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white" :class="isSidebarOpen ? '' : 'justify-center'">
            <i class="fab fa-android w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i>
            <span x-show="isSidebarOpen">Android App</span>
        </a>
        <a href="{{ url('/') }}" target="_blank" class="flex items-center px-6 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white" :class="isSidebarOpen ? '' : 'justify-center'">
            <i class="fas fa-globe w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i>
            <span x-show="isSidebarOpen">Main Site</span>
        </a>
        <a href="#" class="flex items-center px-6 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white" :class="isSidebarOpen ? '' : 'justify-center'">
            <i class="fas fa-tools w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i>
            <span x-show="isSidebarOpen">Developer Tool</span>
        </a>

        <div class="border-t border-gray-200 dark:border-gray-700 mt-4">
            <a href="{{ route('profile.edit') }}" class="flex items-center px-6 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white {{ request()->routeIs('profile.edit') ? 'bg-gray-100 dark:bg-gray-900 text-gray-900 dark:text-white' : '' }}" :class="isSidebarOpen ? '' : 'justify-center'">
                <i class="fas fa-user-circle w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i>
                <span x-show="isSidebarOpen">Profile</span>
            </a>
            <!-- Logout -->
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <a href="{{ route('logout') }}" onclick="event.preventDefault(); this.closest('form').submit();"
                   class="flex items-center px-6 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white" :class="isSidebarOpen ? '' : 'justify-center'">
                    <i class="fas fa-sign-out-alt w-6 text-center" :class="isSidebarOpen ? 'mr-3' : 'mr-0'"></i>
                    <span x-show="isSidebarOpen">Log Out</span>
                </a>
            </form>
        </div>
    </nav>

    <!-- Sidebar Toggle for mobile -->
    <button @click="toggleSidebar" class="absolute top-4 right-4 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white md:hidden">
        <i class="fas fa-times text-xl"></i>
    </button>

</aside>
