@component('mail::message')
# Payment Successful

Dear {{ $transaction->user->name ?? 'User' }},

Thank you for your payment. We are pleased to inform you that your transaction has been successfully processed.

Here are the details of your transaction:
- **Transaction ID:** {{ $transaction->system_trx_id }}
- **Amount Paid:** ৳{{ number_format($transaction->amount, 2) }}
- **Payment Method:** {{ ucfirst(str_replace('-', ' ', $transaction->payment_gateway)) }}
- **Date:** {{ $transaction->created_at->format('d M, Y h:i A') }}

Your funds have been added to your account for the brand: **{{ $transaction->brand->name ?? 'N/A' }}**.

If you have any questions, feel free to contact our support team.

Thanks,<br>
{{ config('app.name') }}
@endcomponent
