@extends('layouts.pay')

@section('content')
    @php
        // Get transaction ID from the URL query string or session. URL is more reliable for client-side flows.
        $transactionId = request('transaction_id') ?? session('last_transaction_id');
        $transaction = null;
        if ($transactionId) {
            $transaction = \App\Models\Transaction::with('brand')->find($transactionId);
        }
    @endphp
    <div class="min-h-screen flex items-center justify-center p-4">
        <div
            class="payment-container w-full max-w-md bg-gray-500 backdrop-blur-xl rounded-2xl shadow-2xl overflow-hidden border border-white/20 text-center">
            <div class="p-8">
                <div class="w-24 h-24 mx-auto bg-green-100 rounded-full flex items-center justify-center animate-pulse">
                    <i class="fas fa-check-circle text-5xl text-green-500"></i>
                </div>

                <h1 class="text-3xl font-bold text-gray-800 mt-6">{{ __('Payment Successful!') }}</h1>
                <p class="text-gray-600 mt-2">{{ __('Thank you! Your payment has been processed successfully.') }}</p>

                @if ($transaction)
                    <div class="mt-8 text-left bg-gray-50 rounded-xl p-4 space-y-3 border border-gray-200">
                        <h2 class="text-lg font-semibold text-gray-800 border-b pb-2 mb-3">Transaction Summary</h2>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">{{ __('Transaction ID:') }}</span>
                            <span class="font-mono text-gray-800">{{ $transaction->trx_id ?? $transaction->system_trx_id }}</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">{{ __('Amount Paid:') }}</span>
                            <span class="font-bold text-gray-800">৳{{ number_format($transaction->amount, 2) }}</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">{{ __('Paid To:') }}</span>
                            <span class="font-semibold text-gray-800">{{ $transaction->brand->name ?? 'N/A' }}</span>
                        </div>
                    </div>
                @endif

                <div class="mt-8">
                    <a href="{{ url('/') }}"
                        class="w-full bg-indigo-600 text-white px-6 py-3 rounded-lg font-bold hover:bg-indigo-700 transition-all duration-300">
                        {{ __('Go to Homepage') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection