@php
    $prefix = auth()->user() && auth()->user()->role === 'admin' ? 'admin.' : 'user.';
    // Determine active brand ID. Prioritize the query parameter.
    // If not present, fall back to the first active brand for the logged-in user.
    $activeBrandIdFromQuery = request()->query('brand_id');
    $defaultBrandId = null;
    if (!$activeBrandIdFromQuery) {
        $user = auth()->user();
        if ($user) {
            $defaultBrandId = $user->brands()->where('status', 1)->first()?->id;
        }
    }
@endphp

<x-modal name="add-funds-modal" focusable x-data="{
    activeBrandId: '{{ $activeBrandIdFromQuery ?? $defaultBrandId }}'
}">
    <form method="post" action="{{ route($prefix . 'funds.store') }}" class="p-6">
        @csrf
        <input type="hidden" name="brand_id" :value="activeBrandId">

        <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
            {{ __('Add Funds to Your Account') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
            {{ __('Please enter the amount you wish to add. The funds will be added to your main balance.') }}
        </p>

        <div class="mt-6">
            <x-input-label for="amount" value="{{ __('Amount') }}" />

            <div class="relative mt-1">
                <x-text-input id="amount" name="amount" type="number" class="block w-full" placeholder="0.00"
                    step="0.01" :value="old('amount')" />
            </div>
            <x-input-error :messages="$errors->addFunds->get('amount')" class="mt-2" />
        </div>

        <div class="mt-6">
            <label for="terms" class="flex items-center">
                <input id="terms" type="checkbox" name="terms" class="rounded dark:bg-gray-900 border-gray-300 dark:border-gray-700 text-indigo-600 shadow-sm focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-offset-gray-800" required>
                <span class="ml-2 text-sm text-gray-600 dark:text-gray-400">{{ __('I understand that after adding funds, I will not make fraudulent disputes or chargebacks.') }}</span>
            </label>
        </div>

        <div class="mt-6 flex justify-end">
            <x-secondary-button x-on:click="$dispatch('close')">
                {{ __('Cancel') }}
            </x-secondary-button>

            <x-primary-button class="ml-3">
                {{ __('Add Funds') }}
            </x-primary-button>
        </div>
    </form>
</x-modal>
