<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'HilnexPay')</title>

    @stack('meta')

    <!-- Favicon -->
    <link rel="icon" href="{{ asset('assets/image/Fav-Icon-black.png') }}" type="image/png">

    <!-- Vite CSS & JS -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    @stack('styles')

    <style>
    /* Additional styles for enhanced navigation */
    .mobile-menu-enter {
        /* Initial state for slide-down animation */
        top: -100%;
    }

    .mobile-menu-enter-active {
        /* Active state for slide-down animation */
        top: 0;
        transition: top 0.3s ease-in-out;
    }

    .mobile-menu-exit {
        opacity: 1;
        transform: translateY(0);
    }

    .mobile-menu-exit-active {
        opacity: 0;
        transform: translateY(-100%);
        transition: opacity 0.3s ease, transform 0.3s ease;
    }

    /* Fix for mobile scroll issues */
    html {
        scroll-behavior: smooth;
        -webkit-overflow-scrolling: touch;
    }

    /* Disable tap highlight on mobile */
    a, button {
        -webkit-tap-highlight-color: transparent;
    }

    /* Prevent body scroll when mobile menu is open */


    /* Also prevent html scroll */
    html.menu-open {
        overflow: hidden;
    }

    body.menu-open {
        position: fixed;
        width: 100%;
        overflow-y: scroll;
    }

    /* Enhanced navigation styles */
    .nav-link {
        position: relative;
        overflow: hidden;
    }

    .nav-link::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 0;
        height: 2px;
        background-color: hsl(var(--primary));
        transition: width 0.3s ease;
    }

    .nav-link:hover::after,
    .nav-link.active::after {
        width: 100%;
    }

    /* Dropdown menu styles */
    .dropdown-menu {
        opacity: 0;
        visibility: hidden;
        transform: translateY(-10px);
        transition: all 0.3s ease;
    }

    .dropdown:hover .dropdown-menu {
        opacity: 1;
        visibility: visible;
        transform: translateY(0);
    }

    /* Mobile menu enhancements */
    .mobile-menu-item {
        position: relative;
        overflow: hidden;
        transition: all 0.3s ease;
    }

    .mobile-menu-item::before {
        content: '';
        position: absolute;
        left: -100%;
        top: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(79, 70, 229, 0.1), transparent);
        transition: left 0.5s ease;
    }

    .mobile-menu-item:hover::before {
        left: 100%;
    }

    /* Button animations */
    .btn-primary {
        position: relative;
        overflow: hidden;
        transition: all 0.3s ease;
    }

    .btn-primary::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
        transition: left 0.5s ease;
    }

    .btn-primary:hover::before {
        left: 100%;
    }

    /* Mobile menu backdrop blur effect */
    #mobile-menu {
        backdrop-filter: blur(5px);
        -webkit-backdrop-filter: blur(5px);
    }

    /* Active page indicator for mobile */
    .mobile-active-indicator {
        width: 4px;
        height: 100%;
        background-color: hsl(var(--primary));
        position: absolute;
        left: 0;
        top: 0;
        transform: scaleY(0);
        transition: transform 0.3s ease;
    }

    .mobile-menu-item.active .mobile-active-indicator {
        transform: scaleY(1);
    }

    /* NEW FIXED MOBILE MENU STYLES */
    #mobile-menu {
        position: fixed !important;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.75);
        backdrop-filter: blur(5px);
        -webkit-backdrop-filter: blur(5px);
        z-index: 130;
        display: none;
    }

    #mobile-menu.open {
        display: block;
    }

    #mobile-menu-content {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: white;
        padding: 1.5rem;
        overflow-y: auto;
        transform: translateY(-100%);
        transition: transform 0.3s ease-in-out;
        z-index: 131;
    }

    #mobile-menu.open #mobile-menu-content {
        transform: translateY(0);
    }

    /* Custom scrollbar styling for mobile */
    #mobile-menu-content::-webkit-scrollbar {
        width: 6px;
    }

    #mobile-menu-content::-webkit-scrollbar-track {
        background: #f7fafc;
        border-radius: 3px;
    }

    #mobile-menu-content::-webkit-scrollbar-thumb {
        background-color: #cbd5e0;
        border-radius: 3px;
    }

    #mobile-menu-content::-webkit-scrollbar-thumb:hover {
        background-color: #a0aec0;
    }

    /* Enhanced mobile menu items */
    .mobile-menu-item {
        display: flex;
        align-items: center;
        padding: 0.75rem 1rem;
        margin-bottom: 0.25rem;
        border-radius: 0.375rem;
        color: #4b5563;
        text-decoration: none;
        position: relative;
        overflow: hidden;
        transition: all 0.3s ease;
    }

    .mobile-menu-item:hover {
        background-color: hsl(var(--primary) / 0.1);
        color: hsl(var(--primary));
    }

    .mobile-menu-item.active {
        background-color: #eef2ff;
        color: #4f46e5;
    }

    /* Hide sidebar and related elements on mobile devices */
    @media (max-width: 1023px) {

        /* Tailwind's lg breakpoint is 1024px. We target screens smaller than that. */
        #sticky-sidebar,
        /* This is the frontend vertical bar */
        #drawer,
        /* This is the menu that slides out from the frontend bar */
        #backdrop,
        /* The backdrop for the drawer */
        aside.w-64.fixed.left-0

        /* This is the dashboard sidebar */
            {
            display: none !important;
        }

        /* Adjust main content to take full width when sidebar is hidden on mobile */
        #app-wrapper,
        #main-nav {
            margin-left: 0 !important;
            left: 0 !important;
            width: 100% !important;
        }
    }

    /* Modal styles */
    .modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        z-index: 140;
        align-items: center;
        /* This will be overridden by JS */
        justify-content: center;
    }

    .modal-content {
        background-color: white;
        padding: 2rem;
        border-radius: 8px;
        max-width: 500px;
        width: 90%;
        max-height: 80vh;
        overflow-y: auto;
        position: relative;
    }

    .modal-close {
        position: absolute;
        top: 1rem;
        right: 1rem;
        background: none;
        border: none;
        font-size: 1.5rem;
        cursor: pointer;
        color: #6b7280;
    }

    .modal-close:hover {
        color: #374151;
    }

    /* Hide scrollbar on desktop */
    </style>
</head>

<body>
    <!-- Converted sticky bar (Sidebar) -->
    <aside id="sticky-sidebar"
        class="fixed left-0 top-0 h-full bg-[#C6C9D4] flex flex-col justify-between items-center py-8 px-4 z-50 w-10 lg:w-20 transition-all duration-300">

        <!-- Menu Trigger -->
        <button id="menu-toggle"
            class="flex flex-col items-center justify-center text-gray-800 hover:text-primary focus:outline-none"
            aria-label="Menu">
            <i class="fas fa-grip text-2xl"></i>
            <span class="text-sm font-medium rotate-[-90deg] whitespace-nowrap mt-8">Menu</span>
        </button>

        <!-- Email Link -->
        <p class="text-sm text-gray-600 hover:text-primary my-auto rotate-[-90deg] whitespace-nowrap">
            <a href="mailto:support@hilnexpay.com">support@hilnexpay.com</a>
        </p>

        <!-- Scroll to Top Indicator -->
        <div id="scroll-indicator" class="flex flex-col items-center cursor-pointer text-gray-800 hover:text-blue-600">
            <a href="#top" class="flex flex-col items-center">
                <span class="text-xs mb-10 rotate-[-90deg] whitespace-nowrap">scroll to top</span>
                <div class="relative w-0.5 h-20 bg-gray-200 rounded-full overflow-hidden">
                    <div id="scroll-progress"
                        class="absolute bottom-0 left-0 w-full bg-gray-800 transition-all duration-200"
                        style="height: 0%;"></div>
                </div>
            </a>
        </div>

    </aside>

    <!-- Placeholder for drawer (sidebar menu) - assuming it's off-canvas -->
    <div id="drawer"
        class="fixed left-0  h-full w-80 bg-white shadow-lg transform -translate-x-full transition-transform duration-300 z-[150]">
        <!-- Drawer content -->
        <div class="p-4 flex flex-col h-full text-center">
            <!-- Logo -->
            <div class="flex justify-center mb-8">
                <img width="200" height="100" src="{{ asset('assets/image/hilnex-logo1.png') }}"
                    class="max-w-full h-auto" alt="hilnexpay Logo"
                    srcset="{{ asset('assets/image/hilnex-logo1.png') }} 4 300w" sizes="(max-width:100px) 100vw, 100px">
            </div>

            <!-- Navigation Menu -->
            <div class="flex-grow flex items-center justify-center">
                <ul class="flex flex-col items-start gap-4 list-none">
                    <li>
                        <a href="#" class="text-gray-700 hover:text-primary transition-colors duration-300">
                            About Company
                        </a>
                    </li>
                    <li>
                        <a href="#" class="text-gray-700 hover:text-primary transition-colors duration-300">
                            Blog
                        </a>
                    </li>
                    <li>
                        <a href="#" class="text-gray-700 hover:text-primary transition-colors duration-300">
                            News
                        </a>
                    </li>
                    <li>
                        <a href="#" class="text-gray-700 hover:text-primary transition-colors duration-300">
                            Privacy Policy
                        </a>
                    </li>
                    <li>
                        <a href="#" class="text-gray-700 hover:text-primary transition-colors duration-300">
                            Terms and Conditions
                        </a>
                    </li>
                </ul>
            </div>

            <!-- Bottom Content Section -->
            <div class="mt-auto text-center items-center justify-center py-4">
                <!-- Heading Text -->
                <div class="mb-4">
                    <p class="text-sm text-gray-700">
                        Looking for collaboration for your next project? Do not hesitate to contact us to
                        say hello.
                    </p>
                </div>

                <!-- Email Link -->
                <div class="mb-6">
                    <p class="text-sm">
                        <a href="mailto:support@hilnexpay.com" class="text-primary hover:text-primary/80 transition-colors duration-300">
                            support@hilnexpay.com
                        </a>
                    </p>
                </div>

                <!-- Social Icons can go here if needed -->
                <div class="flex space-x-4 mt-4 justify-center">
                    <a href="#" class="text-gray-600 hover:text-primary transition-colors duration-300">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a href="#" class="text-gray-600 hover:text-primary transition-colors duration-300">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <a href="#" class="text-gray-600 hover:text-primary transition-colors duration-300">
                        <i class="fab fa-linkedin-in"></i>
                    </a>
                    <a href="#" class="text-gray-600 hover:text-primary transition-colors duration-300">
                        <i class="fab fa-instagram"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Backdrop for drawer -->
    <div id="backdrop" class="fixed inset-0  hidden z-[140]"></div>

    <!-- Navigation -->
    <nav id="main-nav"
        class="fixed top-0 right-0 bg-[#C6C9D4] transition-all duration-300 ease-in-out z-[50] py-4 md:left-10 lg:left-20 left-0">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="relative flex items-center justify-between h-full w-full">
                <div class="flex-shrink-0 flex items-center justify-start lg:w-48">
                    <a href="{{ url('/') }}" class="shrink-0">
                        <img class="h-10 w-auto" src="{{ asset('assets/image/hilnex-logo1.png') }}" alt="Demo Pay">
                    </a>
                </div>

                <!-- Centered Navigation Links -->
                <div class="hidden md:flex items-center justify-center flex-1">
                    <div class="flex items-baseline space-x-1">
                        <a href="{{ route('home') }}" title="Home"
                            class="nav-link h-full flex items-center px-2 font-medium transition-all duration-300 border-b-2 {{ request()->routeIs('home') && !request()->get('_fragment') ? 'border-secondary text-secondary active' : 'border-transparent text-gray-600 hover:border-primary hover:text-primary' }}">
                            Home
                        </a>

                        <div class="dropdown h-full flex items-center relative">
                            <a href="{{ url('/#features') }}"
                                class="nav-link h-full flex items-center px-2 font-medium transition-all duration-300 border-b-2 {{ request()->routeIs('home') && request()->get('_fragment') === 'features' ? 'border-secondary text-secondary active' : 'border-transparent text-gray-600 hover:border-primary hover:text-primary' }}">
                                Features
                                <i class="fas fa-chevron-down ml-1 text-xs"></i>
                            </a>
                            <div
                                class="dropdown-menu absolute top-full left-0 mt-2 w-48 bg-white rounded-md shadow-lg py-1 z-50">
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-primary/10 hover:text-primary transition-colors">Payment Processing</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-primary/10 hover:text-primary transition-colors">Security</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-primary/10 hover:text-primary transition-colors">Analytics</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-primary/10 hover:text-primary transition-colors">Integration</a>
                            </div>
                        </div>
                        <a href="{{ route('pricing') }}"
                            class="nav-link h-full flex items-center px-2 font-medium transition-all duration-300 border-b-2 {{ request()->routeIs('pricing') ? 'border-secondary text-secondary active' : 'border-transparent text-gray-600 hover:border-primary hover:text-primary' }}">
                            Pricing
                        </a>
                        <a href="{{ route('about') }}"
                            class="nav-link h-full flex items-center px-2 font-medium transition-all duration-300 border-b-2 {{ request()->routeIs('about') ? 'border-secondary text-secondary active' : 'border-transparent text-gray-600 hover:border-primary hover:text-primary' }}">
                            About
                        </a>
                        <a href="{{ route('contact') }}"
                            class="nav-link h-full flex items-center px-2 font-medium transition-all duration-300 border-b-2 {{ request()->routeIs('contact') ? 'border-secondary text-secondary active' : 'border-transparent text-gray-600 hover:border-primary hover:text-primary' }}">
                            Contact
                        </a>
                    </div>
                </div>

                <div class="hidden md:flex items-center justify-end flex-shrink-0 w-48">
                    <!-- Login/Logout Button -->
                    <div>
                        @guest
                        <a href="{{ route('login') }}" class="btn btn-primary btn-lg no-underline  shadow-none inline-flex items-center justify-center text-center">Login</a>
                        @else
                        <div class="dropdown relative">
                            <a href="{{ auth()->user()->role === 'admin' ? route('admin.dashboard') : route('user.dashboard') }}"
                                class="flex items-center text-gray-800 font-medium mr-4 hover:text-primary transition-colors no-underline">
                                <span>Dashboard</span>
                                <i class="fas fa-chevron-down ml-1 text-xs"></i>
                            </a>
                            <div
                                class="dropdown-menu absolute top-full right-0 mt-2 w-48 bg-white rounded-md shadow-lg py-1 z-50">
                                <a href="{{ route('profile.edit') }}"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-primary/10 hover:text-primary transition-colors"><i
                                        class="fas fa-user mr-2"></i>Profile</a>
                                <a href="#"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-primary/10 hover:text-primary transition-colors"><i
                                        class="fas fa-cog mr-2"></i>Settings</a>
                                <div class="border-t border-gray-100 my-1"></div>
                                <a href="{{ route('logout') }}"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-primary/10 hover:text-primary transition-colors"
                                    onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                    <i class="fas fa-sign-out-alt mr-2"></i>Logout
                                </a>
                            </div>
                        </div>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="hidden">
                            @csrf
                        </form>
                        @endguest
                    </div>
                </div>
                <div class="md:hidden flex items-center ml-auto">
                    <button id="mobile-menu-button"
                        class="text-primary hover:text-primary/90 focus:outline-none transition-colors" aria-label="Open main menu" aria-controls="mobile-menu" aria-expanded="false">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                </div>
            </div>
        </div>
    </nav>

    <!-- Mobile menu -->
    <div id="mobile-menu" class="md:hidden z-[130]" role="dialog" aria-modal="true"
        aria-labelledby="mobile-menu-heading" aria-hidden="true">
        <div id="mobile-menu-content" class="bg-white shadow-lg p-6">
            <div class="flex justify-between items-center mb-6">
                <h2 id="mobile-menu-heading" class="text-xl font-bold text-gray-800">Menu</h2>
                <button id="mobile-menu-close-button" class="text-gray-600 hover:text-primary transition-colors"
                    aria-label="Close main menu">
                    <i class="fas fa-times text-2xl"></i>
                </button>
            </div>
            <nav class="space-y-2">
                <a href="{{ route('home') }}"
                    class="mobile-menu-item flex items-center py-3 px-4 text-gray-600 rounded-md transition-all duration-200 relative {{ request()->routeIs('home') ? 'active' : '' }}">
                    <div class="mobile-active-indicator"></div>
                    <i class="fas fa-home mr-3 w-5 text-center"></i>
                    <span>Home</span>
                </a>
                <a href="{{ url('/#features') }}"
                    class="mobile-menu-item flex items-center py-3 px-4 text-gray-600 rounded-md transition-all duration-200 relative {{ request()->routeIs('home') && request()->get('_fragment') === 'features' ? 'active' : '' }}">
                    <div class="mobile-active-indicator"></div>
                    <i class="fas fa-star mr-3 w-5 text-center"></i>
                    <span>Features</span>
                </a>
                <a href="{{ route('pricing') }}"
                    class="mobile-menu-item flex items-center py-3 px-4 text-gray-600 rounded-md transition-all duration-200 relative {{ request()->routeIs('pricing') ? 'active' : '' }}">
                    <div class="mobile-active-indicator"></div>
                    <i class="fas fa-tag mr-3 w-5 text-center"></i>
                    <span>Pricing</span>
                </a>
                <a href="{{ route('about') }}"
                    class="mobile-menu-item flex items-center py-3 px-4 text-gray-600 rounded-md transition-all duration-200 relative {{ request()->routeIs('about') ? 'active' : '' }}">
                    <div class="mobile-active-indicator"></div>
                    <i class="fas fa-info-circle mr-3 w-5 text-center"></i>
                    <span>About</span>
                </a>
                <a href="{{ route('contact') }}"
                    class="mobile-menu-item flex items-center py-3 px-4 text-gray-600 rounded-md transition-all duration-200 relative {{ request()->routeIs('contact') ? 'active' : '' }}">
                    <div class="mobile-active-indicator"></div>
                    <i class="fas fa-envelope mr-3 w-5 text-center"></i>
                    <span>Contact</span>
                </a>

                <!-- NEW: Modal trigger button in mobile menu -->
                <button id="modal-trigger"
                    class="mobile-menu-item flex items-center py-3 px-4 text-gray-600 rounded-md transition-all duration-200 relative w-full text-left">
                    <div class="mobile-active-indicator"></div>
                    <i class="fas fa-info-circle mr-3 w-5 text-center"></i>
                    <span>App Information</span>
                </button>
            </nav>
            <div class="border-t border-gray-200 mt-4 pt-4">
                @guest
                <a href="{{ route('login') }}" class="btn btn-primary w-full">Login</a>
                @else
                <div class="space-y-2">
                    <div class="flex items-center py-2 px-4 bg-primary/10 rounded-md">
                        <i class="fas fa-user-circle text-primary mr-3"></i>
                        <span class="text-gray-800">Hi, {{ Auth::user()->name }}</span>
                    </div>
                    <a href="{{ route('logout') }}" class="btn btn-secondary w-full"
                        onclick="event.preventDefault(); document.getElementById('logout-form-mobile').submit();">Logout</a>
                    <form id="logout-form-mobile" action="{{ route('logout') }}" method="POST" class="hidden">
                        @csrf</form>
                </div>
                @endguest
            </div>
        </div>
    </div>

    <!-- NEW: App Information Modal -->
    <div id="info-modal" class="modal" style="display: none;">
        <div class="modal-content dark:bg-gray-800">
            <button id="modal-close" class="modal-close dark:text-gray-400 dark:hover:text-white">&times;</button>
            <h2 class="text-2xl font-bold mb-4 text-gray-900 dark:text-gray-100">App Information</h2>
            <div class="space-y-4 text-gray-700 dark:text-gray-300">
                <p>
                    <strong>App Name:</strong> HilnexPay
                </p>
                <p>
                    <strong>Version:</strong> 1.0.0
                </p>
                <p>
                    <strong>Description:</strong> A seamless and secure payment automation platform.
                </p>
                <p>
                    <strong>Support:</strong> For any help, please contact us at
                    <a href="mailto:support@hilnexpay.com" class="text-primary dark:text-primary-light hover:underline">support@hilnexpay.com</a>.
                </p>
            </div>
        </div>
    </div>

    <div id="app-wrapper" class="flex flex-col min-h-screen ease-in-out md:ml-10 lg:ml-20">

        <main class="flex-grow w-full">
            <main class="flex-grow w-full overflow-x-hidden">
                @yield('content')
            </main>

            <!-- Footer -->
            <footer class="bg-gray-800 text-white py-12 w-full overflow-x-hidden">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8"> <!-- Keeping padding for content alignment -->
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                        <div class="md:col-span-1 col-span-full">
                            <a href="{{ url('/') }}">
                                <img class="h-10 w-auto mb-4" src="{{ asset('assets/image/hilnex-logo3.png') }}"
                                    alt="Demo Pay">
                            </a>
                            <p class="text-gray-400">Your one-stop platform for seamless and secure payment automation.
                            </p>
                            <div class="flex space-x-4 mt-4">
                                <a href="#" class="text-gray-400 hover:text-white transition-colors"><i
                                        class="fab fa-twitter"></i></a>
                                <a href="#" class="text-gray-400 hover:text-white transition-colors"><i
                                        class="fab fa-facebook"></i></a>
                                <a href="#" class="text-gray-400 hover:text-white transition-colors"><i
                                        class="fab fa-linkedin"></i></a>
                                <a href="#" class="text-gray-400 hover:text-white transition-colors"><i
                                        class="fab fa-instagram"></i></a>
                            </div>
                        </div>

                        <div class="md:col-span-3 col-span-full grid  grid-cols-2 md:grid-cols-3 gap-8">
                            <div>
                                <h4 class="font-bold mb-4">Product</h4>
                                <ul class="space-y-2">
                                    <li><a href="{{ url('/#features') }}"
                                            class="text-gray-400 hover:text-white transition-colors">Features</a>
                                    </li>
                                    <li><a href="{{ route('pricing') }}"
                                            class="text-gray-400 hover:text-white transition-colors">Pricing</a></li>
                                    <li><a href="#"
                                            class="text-gray-400 hover:text-white transition-colors">Integrations</a>
                                    </li>
                                    <li><a href="#" class="text-gray-400 hover:text-white transition-colors">API</a>
                                    </li>
                                </ul>
                            </div>

                            <div>
                                <h4 class="font-bold mb-4">Resources</h4>
                                <ul class="space-y-2">
                                    <li><a href="#"
                                            class="text-gray-400 hover:text-white transition-colors">Documentation</a>
                                    </li>
                                    <li><a href="#" class="text-gray-400 hover:text-white transition-colors">Guides</a>
                                    </li>
                                    <li><a href="#" class="text-gray-400 hover:text-white transition-colors">Blog</a>
                                    </li>
                                    <li><a href="#" class="text-gray-400 hover:text-white transition-colors">Support</a>
                                    </li>
                                </ul>
                            </div>

                            <div>
                                <h4 class="font-bold mb-4">Company</h4>
                                <ul class="space-y-2">
                                    <li><a href="{{ route('about') }}"
                                            class="text-gray-400 hover:text-white transition-colors">About</a></li>
                                    <li><a href="#" class="text-gray-400 hover:text-white transition-colors">Careers</a>
                                    </li>
                                    <li><a href="{{ route('contact') }}"
                                            class="text-gray-400 hover:text-white transition-colors">Contact</a></li>
                                    <li><a href="#" class="text-gray-400 hover:text-white transition-colors">Privacy
                                            Policy</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="border-t border-gray-700 mt-12 pt-6 text-center text-gray-400">
                        <p>&copy; {{ date('Y') }} HilnexPay. All rights reserved.</p>
                    </div>
                </div>
            </footer>

            <a href="#" id="scroll-to-top"
                class="fixed bottom-5 right-5 bg-black text-white w-8 h-10 flex items-center justify-center rounded-full shadow-lg hover:bg-primary transition-all duration-300 opacity-0 z-[99] md:hidden">
                <i class="fas fa-arrow-up"></i>
            </a>

            <!-- Scripts -->
            <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Mobile menu functionality
                const menuButton = document.getElementById('mobile-menu-button');
                const closeButton = document.getElementById('mobile-menu-close-button');
                const menuOverlay = document.getElementById('mobile-menu');
                const menuContent = document.getElementById('mobile-menu-content');
                const body = document.body;
                const html = document.documentElement;
                let scrollPosition = 0;

                // Function to open mobile menu
                function openMobileMenu() {
                    menuOverlay.classList.add('open');
                    menuOverlay.setAttribute('aria-hidden', 'false');
                    menuButton.setAttribute('aria-expanded', 'true');

                    // Save scroll position and lock body
                    scrollPosition = window.scrollY;

                    // Prevent body scroll
                    body.classList.add('menu-open');
                    html.classList.add('menu-open');
                    body.style.top = `-${scrollPosition}px`;

                    closeButton.focus();
                }

                // Function to close mobile menu
                function closeMobileMenu() {
                    menuOverlay.classList.remove('open');
                    menuOverlay.setAttribute('aria-hidden', 'true');
                    menuButton.setAttribute('aria-expanded', 'false');

                    // Restore body scroll
                    body.classList.remove('menu-open');
                    html.classList.remove('menu-open');
                    body.style.removeProperty('top');

                    window.scrollTo(0, scrollPosition);

                    menuButton.focus();
                }

                // Event listeners for mobile menu
                if (menuButton && menuOverlay && menuContent && closeButton) {
                    menuButton.addEventListener('click', openMobileMenu);
                    closeButton.addEventListener('click', closeMobileMenu);

                    // Close menu when clicking on overlay (outside menu content)
                    menuOverlay.addEventListener('click', function(e) {
                        if (e.target === menuOverlay) {
                            closeMobileMenu();
                        }
                    });

                    // Close menu when clicking on menu links
                    const menuLinks = menuContent.querySelectorAll('a');
                    menuLinks.forEach(link => {
                        link.addEventListener('click', function(e) {
                            // Only close if it's not a modal trigger
                            if (!this.id.includes('modal-trigger')) {
                                closeMobileMenu();
                            }
                        });
                    });

                    // Close menu with Escape key
                    document.addEventListener('keydown', function(e) {
                        if (e.key === 'Escape' && menuOverlay.classList.contains('open')) {
                            closeMobileMenu();
                        }
                    });

                    // Handle resize events
                    window.addEventListener('resize', function() {
                        if (window.innerWidth > 768 && menuOverlay.classList.contains('open')) {
                            closeMobileMenu();
                        }
                    });
                }

                // Modal functionality
                const modalTrigger = document.getElementById('modal-trigger');
                const drawerModalTrigger = document.getElementById('drawer-modal-trigger');
                const modal = document.getElementById('info-modal');
                const modalClose = document.getElementById('modal-close');

                const stickySidebar = document.querySelector('aside.fixed.left-0');

                if (modalTrigger && modal && modalClose) {
                    modalTrigger.addEventListener('click', function() {
                        // Close mobile menu first if open
                        if (menuOverlay && menuOverlay.classList.contains('open')) {
                            closeMobileMenu();
                        }

                        // Show modal after a short delay
                        setTimeout(() => {
                            modal.style.display = 'flex';
                            body.style.overflow = 'hidden';
                            if (stickySidebar) stickySidebar.classList.add('hidden');
                            modalClose.focus();
                        }, 300);
                    });

                    if (drawerModalTrigger) {
                        drawerModalTrigger.addEventListener('click', (e) => {
                            e.preventDefault(); // Prevent default link behavior if it's an anchor
                            // Close drawer first
                            if (drawer && !drawer.classList.contains('-translate-x-full')) {
                                drawer.classList.add('-translate-x-full');
                                backdrop.classList.add('hidden');
                            }
                            // Show modal
                            modal.style.display = 'flex';
                            // Prevent body scroll
                            document.body.style.overflow = 'hidden';
                            document.documentElement.style.overflow = 'hidden';
                            if (stickySidebar) stickySidebar.classList.add('hidden');
                            modalClose.focus();
                        });
                    }

                    const closeModal = () => {
                        document.body.style.overflow = '';
                        document.documentElement.style.overflow = '';
                        // Re-enable scrolling when modal is closed
                        modal.style.display = 'none';
                        body.classList.remove('menu-open');
                        if (stickySidebar) stickySidebar.classList.remove('hidden');
                    };

                    modalClose.addEventListener('click', closeModal);

                    // Close modal when clicking outside
                    modal.addEventListener('click', (e) => {
                        // Check if the click is on the modal backdrop itself, not on its children
                        if (e.target.id === 'info-modal') {
                            closeModal();
                        }
                    });

                    // Close modal with Escape key
                    document.addEventListener('keydown', (e) => {
                        if (e.key === 'Escape' && modal.style.display !== 'none') {
                            closeModal();
                        }
                    });
                }

                // Sticky navigation (always fixed, change style on scroll)
                const nav = document.getElementById('main-nav');
                let navHeight = nav.offsetHeight;
                const sidebar = document.getElementById('sticky-sidebar');
                const mainContent = document.querySelector('main');
                const appWrapper = document.getElementById('app-wrapper');
                let lastScrollTop = 0; // For scroll direction detection

                // Set initial padding to body to reserve space for fixed nav
                if (appWrapper) appWrapper.style.paddingTop = nav.offsetHeight +
                    'px'; // Use nav.offsetHeight directly

                // Update nav height and padding on window resize
                window.addEventListener('scroll', function() {
                    let currentScroll = window.pageYOffset || document.documentElement.scrollTop;

                    // For mobile view, hide/show nav on scroll
                    if (window.innerWidth < 768) { // Only apply on mobile
                        if (currentScroll > lastScrollTop && currentScroll > nav.offsetHeight) {
                            // Scroll Down
                            nav.style.transform = 'translateY(-100%)';
                        } else {
                            // Scroll Up
                            nav.style.transform = 'translateY(0)';
                        }
                    }

                    if (currentScroll > 50) {
                        nav.classList.remove('bg-[#C6C9D4]');
                        nav.classList.add('bg-white', 'shadow-md');
                        if (sidebar) {
                            sidebar.classList.remove('bg-[#C6C9D4]');
                            sidebar.classList.add('bg-white', 'shadow-md');
                        }
                    } else {
                        nav.classList.add('bg-[#C6C9D4]');
                        nav.classList.remove('bg-white', 'shadow-md');
                        if (sidebar) {
                            sidebar.classList.add('bg-[#C6C9D4]');
                            sidebar.classList.remove('bg-white', 'shadow-md');
                        }
                    }

                    // Update last scroll position for next scroll event
                    lastScrollTop = currentScroll <= 0 ? 0 : currentScroll;
                });

                // Show/hide scroll-to-top button on mobile
                const scrollToTopBtn = document.getElementById('scroll-to-top');
                if (scrollToTopBtn) {
                    window.addEventListener('scroll', function() {
                        if (window.pageYOffset > 200) {
                            scrollToTopBtn.classList.replace('opacity-0', 'opacity-100');
                        } else {
                            scrollToTopBtn.classList.replace('opacity-100', 'opacity-0');
                        }
                    });
                }

                window.addEventListener('resize', function() {
                    navHeight = nav.offsetHeight;
                    if (appWrapper) appWrapper.style.paddingTop = nav.offsetHeight + 'px';
                });

                // Scroll to top button
                const scrollToTopButton = document.getElementById('scroll-to-top');
                if (scrollToTopButton) {
                    scrollToTopButton.addEventListener('click', (e) => {
                        e.preventDefault();
                        window.scrollTo({
                            top: 0,
                            behavior: 'smooth'
                        });
                    });
                }

                // Improved smooth scrolling for anchor links
                document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                    anchor.addEventListener('click', function(e) {
                        const href = this.getAttribute('href');

                        // Skip if it's the scroll-to-top button or just a placeholder "#"
                        if (this.id === 'scroll-to-top' || href === '#') return;

                        const target = document.querySelector(href);
                        if (target) {
                            e.preventDefault();

                            // Calculate offset for fixed header
                            const headerHeight = nav.offsetHeight;
                            const targetPosition = target.getBoundingClientRect().top + window
                                .pageYOffset - headerHeight;

                            window.scrollTo({
                                top: targetPosition,
                                behavior: 'smooth'
                            });
                        }
                    });
                });

                // Fix for mobile touch scrolling
                let touchStartY = 0;
                document.addEventListener('touchstart', (e) => {
                    touchStartY = e.touches[0].clientY;
                }, {
                    passive: true
                });

                document.addEventListener('touchmove', (e) => {
                    // Prevent default only in specific cases to maintain smooth scrolling
                    if (e.touches.length > 1) {
                        e.preventDefault();
                    }
                }, {
                    passive: false
                });

                // Enhanced dropdown functionality for mobile
                const dropdowns = document.querySelectorAll('.dropdown');
                dropdowns.forEach(dropdown => {
                    const trigger = dropdown.querySelector('a, button');

                    // For mobile, make dropdowns clickable
                    if (window.innerWidth < 768) {
                        trigger.addEventListener('click', (e) => {
                            e.preventDefault();
                            const menu = dropdown.querySelector('.dropdown-menu');

                            // Close all other dropdowns
                            document.querySelectorAll('.dropdown-menu').forEach(otherMenu => {
                                if (otherMenu !== menu) {
                                    otherMenu.classList.remove('active');
                                }
                            });

                            // Toggle current dropdown
                            menu.classList.toggle('active');
                        });
                    }
                });

                // Close dropdowns when clicking outside
                document.addEventListener('click', (e) => {
                    if (!e.target.closest('.dropdown')) {
                        document.querySelectorAll('.dropdown-menu').forEach(menu => {
                            menu.classList.remove('active');
                        });
                    }
                });
            });


            // <!-- Sidebar Script -->

            // Menu Toggle Functionality
            const menuToggle = document.getElementById('menu-toggle');
            const drawer = document.getElementById('drawer');
            const backdrop = document.getElementById('backdrop');
            const drawerClose = document.getElementById('drawer-close');

            function closeDrawer() {
                drawer.classList.add('-translate-x-full');
                backdrop.classList.add('hidden');
            }

            // Only initialize sidebar functionality on larger screens
            if (window.innerWidth > 768) {
                menuToggle.addEventListener('click', () => {
                    drawer.classList.toggle('-translate-x-full');
                    backdrop.classList.toggle('hidden');
                });

                backdrop.addEventListener('click', closeDrawer);
                if (drawerClose) {
                    drawerClose.addEventListener('click', closeDrawer);
                }
            }

            // Scroll to Top Functionality
            const scrollLinks = document.querySelectorAll('a[href="#top"]');
            scrollLinks.forEach(link => {
                link.addEventListener('click', (e) => {
                    e.preventDefault();
                    window.scrollTo({
                        top: 0,
                        behavior: 'smooth'
                    });
                });
            });

            // Scroll Progress Indicator
            const scrollProgress = document.getElementById('scroll-progress');
            window.addEventListener('scroll', () => {
                const scrollTop = document.documentElement.scrollTop || document.body.scrollTop;
                const scrollHeight = document.documentElement.scrollHeight - document.documentElement
                    .clientHeight;
                const scrolled = (scrollTop / scrollHeight) * 100;
                scrollProgress.style.height = `${scrolled}%`;
            });
            </script>

            @stack('scripts')
</body>

</html>