<?php $__env->startSection('title', 'HilnexPay - Seamless & Secure Payment Automation'); ?>

<?php $__env->startPush('meta'); ?>
<meta name="description"
    content="HilnexPay is your one-stop platform for seamless and secure payment automation. We specialise in streamlining payment processes for businesses and individuals, offering features like recurring billing, real-time transaction tracking, and integration with multiple payment gateways.">
<meta name="theme-color" content="#45">
<meta name="keywords" content="demopay, amarpay, payment gateway, uddoktapay">

<!-- Open Graph Meta Tags -->
<meta property="og:type" content="website">
<meta property="og:title" content="HilnexPay">
<meta property="og:description"
    content="HilnexPay is your one-stop platform for seamless and secure payment automation.">
<meta property="og:image" content="<?php echo e(asset('assets/image/Fav-icon-black.png')); ?>">
<meta property="og:url" content="<?php echo e(url('/')); ?>">
<meta property="og:site_name" content="HilnexPay">

<!-- Twitter Card Meta Tags -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:url" content="<?php echo e(url('/')); ?>">
<meta name="twitter:title" content="HilnexPay">
<meta name="twitter:description"
    content="HilnexPay is your one-stop platform for seamless and secure payment automation.">
<meta name="twitter:image" content="<?php echo e(asset('assets/image/Fav-icon-black.png')); ?>">

<!-- Favicon -->
<link rel="icon" type="image/png" href="<?php echo e(asset('assets/image/Fav-icon-black.png')); ?>">

<!-- AOS Library for scroll animations -->
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
<!-- PureCounter for animated number counters (Counts Section) -->
<script src="https://cdn.jsdelivr.net/npm/@srexi/purecounterjs/dist/purecounter_vanilla.js"></script>
<!-- Bootstrap Icons for icons used throughout the page -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
<!-- SwiperJS CSS for the logo carousel (Trusted By Section) -->
<link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* We Offer Section: Box styles */
.box {
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    transition: all 0.3s ease;
}

/* We Offer Section: Box hover effect */
.box:hover {
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
}

/* Hero Section: Floating elements container */
.floating-elements {
    position: absolute;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    pointer-events: none;
}

/* Hero Section: Individual floating elements */
.floating-element {
    position: absolute;
    background: white;
    border-radius: 10px;
    padding: 10px 15px;
    box-shadow: 0 10px 45px rgba(0, 0, 0, 0.1);
    display: flex;
    align-items: center;
    font-size: 0.9rem;
    font-weight: 500;
    animation: float 6s ease-in-out infinite;
}

/* Hero Section: Floating element icons */
.floating-element i {
    margin-right: 8px;
    color: var(--primary);
}

.element-1 {
    top: 20%;
    left: 5%;
    animation-delay: 0s;
}

.element-2 {
    top: 60%;
    right: 10%;
    animation-delay: 2s;
}

.element-3 {
    bottom: 45%;
    left: 15%;
    animation-delay: 4s;
}

/* Hero Section: Floating animation for elements */
@keyframes float {
    0% {
        transform: translateY(0) rotate(0deg);
    }

    50% {
        transform: translateY(-20px) rotate(5deg);
    }

    100% {
        transform: translateY(0) rotate(0deg);
    }
}

/* Hero Section: Arrow icon hover effect on 'Get Started' button */
.btn-get-started:hover i {
    transform: translateX(5px);
}

/* Hero Section: 3D perspective effect on the main image */
.hero-img {
    transform: perspective(1000px) rotateY(-5deg) rotateX(5deg);
    transition: transform 0.5s ease;
}

/* Hero Section: Image hover effect to reset perspective */
.hero-img:hover {
    transform: perspective(1000px) rotateY(0) rotateX(0);
}

/* Counts Section: Style for the count boxes */
.count-box {
    transition: transform 0.4s ease, box-shadow 0.4s ease;
}

.count-box:hover {
    transform: translateY(-12px);
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
}

.count-box:hover i {
    transform: scale(1.15);
}

/* Payment Channels Section: Keyframes for the logo light-up animation */
@keyframes lightUp {
    0% {
        filter: grayscale(100%);
    }

    90% {
        filter: grayscale(100%);
    }

    95% {
        filter: grayscale(0%);
    }

    100% {
        filter: grayscale(100%);
    }
}

/* Payment Channels Section: Class to apply the light-up animation */
.animate-light-up {
    animation: lightUp 10s infinite ease-in-out;
}

/* Payment Channels Section: Logo styles */
.payment-channel-logo {
    filter: grayscale(100%);
    transition: filter 0.3s ease-in-out;
}

/* Payment Channels Section: Glow effect on hover or when 'glow' class is added */
.payment-channel-logo.glow,
.payment-channel-logo-container:hover .payment-channel-logo {
    filter: grayscale(0%);
}

.payment-channel-logo-container:hover {
    transform: scale(1.05);
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<!-- Hero Section -->
<section class="min-h-screen flex items-center relative bg-gray-900 text-white overflow-hidden w-full">
    <video id="background-video" autoplay loop muted playsinline
        class="absolute z-0 w-full h-full object-cover blur-sm">
        <source src="<?php echo e(asset('assets/videos/vecteezy_young-woman.mp4')); ?>" type="video/mp4">
    </video>

    <div class="absolute z-10 w-full h-full bg-black opacity-25"></div>

    <!-- Gradient Shapes -->
    <div
        class="absolute w-[600px] h-[600px] rounded-full bg-gradient-to-br from-[#1a157c] to-[#290e14] opacity-10 -top-[450px] right-0 translate-x-1/3 z-0">
    </div>
    <div
        class="absolute w-[400px] h-[400px] rounded-full bg-gradient-to-br from-[#1a157c] to-[#ff6584] opacity-10 -bottom-[200px] left-0 -translate-x-1/3 z-0">
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 w-full">
        <div class="flex flex-col lg:flex-row items-center py-20">
            <!-- Left Text -->
            <div class="w-full lg:w-1/2 px-4 text-left lg:text-left" data-aos="fade-up">
                <h1 class="text-4xl sm:text-5xl lg:text-5xl font-extrabold mb-6 leading-tight">
                    Seamless & Secure Payment Automation
                </h1>
                <h2 class="text-lg sm:text-xl lg:text-2xl font-normal mb-8 text-gray-200 leading-relaxed"
                    data-aos-delay="200">
                    HilnexPay is your one-stop platform for streamlining payment processes for businesses and
                    individuals.
                </h2>

                <div class="mt-12 flex flex-wrap justify-center lg:justify-start gap-6 sm:gap-8" data-aos-delay="400">
                    <div class="flex flex-col text-center">
                        <span class="text-3xl lg:text-4xl font-bold text-[#a9a9aa]">99.9%</span>
                        <span class="text-sm text-[#a9a9aa]">Uptime</span>
                    </div>
                    <div class="flex flex-col text-center">
                        <span class="text-3xl lg:text-4xl font-bold text-[#a9a9aa]">2M+</span>
                        <span class="text-sm text-[#a9a9aa]">Transactions</span>
                    </div>
                    <div class="flex flex-col text-center">
                        <span class="text-3xl lg:text-4xl font-bold text-[#a9a9aa]">24/7</span>
                        <span class="text-sm text-[#a9a9aa]">Support</span>
                    </div>
                </div>

                <div class="mt-8" data-aos-delay="600">
                    <a href="<?php echo e(route('register')); ?>"
                        class="btn btn-primary btn-lg no-underline btn-get-started px-6 py-3 sm:px-8 sm:py-4 shadow-none inline-flex items-center justify-center text-center">
                        <span class="sm:whitespace-nowrap">
                            Sign-up in 5 minutes for a free 7 day trial!
                            <i class="bi bi-arrow-right ml-2"></i>
                        </span>
                    </a>
                </div>
            </div>

            <!-- Right Image -->
            <div class="w-full lg:w-1/2 px-4 mt-12 lg:mt-0 relative flex justify-center items-center overflow-hidden"
                data-aos="zoom-out" data-aos-delay="400">
                <img src="<?php echo e(asset('assets/image/payment-chart.avif')); ?>" class="max-w-full rounded-2xl shadow-2xl"
                    alt="Payment Dashboard">

                <div class="floating-elements text-black">
                    <div class="floating-element element-1"><i class="bi bi-shield-check"></i> Secure Payments</div>
                    <div class="floating-element element-2"><i class="bi bi-lightning"></i> Fast Processing</div>
                    <div class="floating-element element-3"><i class="bi bi-graph-up"></i> Real-time Analytics</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Text Section -->
<section class="w-full bg-gray-900 text-white py-10">
    <div
        class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex flex-col md:flex-row items-center justify-between text-center md:text-left">
        <!-- Left Column -->
        <div class="flex flex-col items-center md:items-start space-y-4">
            <!-- Logo --> <img src="<?php echo e(asset('assets/image/svg/path.svg')); ?>" alt="hilnexpay Logo"
                class="w-20 h-auto" /> <!-- Heading -->
            <p class="text-lg md:text-xl leading-relaxed max-w-md"> Experience the <b class="text-primary">all-in-one
                    digital payment</b> platform that boosts your business. </p>
        </div> <!-- Right Column -->
        <div class="flex items-center justify-center lg:border-l-2  space-x-4 mt-8 md:mt-0">
            <!-- Odometer Counter -->
            <div id="odometer-counter"
                class="text-9xl sm:text-9xl justify-center pl-5 font-extrabold text-primary leading-none flex overflow-hidden">
            </div>

            <!-- Text (Right of Number) -->
            <div class="text-sm uppercase tracking-wider text-gray-400 leading-tight">
                <span class="relative inline-block">
                    <span class="absolute bottom-0 left-0 w-full h-1/2 bg-blue-400 bg-opacity-20 -z-10"></span>
                    Years of<br>experience
                </span>
            </div>
        </div>
    </div>
</section>

<!-- We Offer Section -->
<section id="about" class="py-16 bg-white overflow-hidden">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <header class="text-center mb-12">
            <h2 class="text-3xl font-bold text-gray-800 mb-2">We Offer</h2>
            <p class="text-gray-600 max-w-2xl mx-auto">Our guiding principles that empower seamless payment solutions
            </p>
        </header>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php $__currentLoopData = [
            ['Save Time', 'Save-Time.png', 'Simplify your payment processes...'],
            ['Seamless Integration', 'Seamless-Integration.png', 'Easily connect and integrate...'],
            ['Automate Personal Accounts', 'Automate-Personal-Accounts.png', 'Streamline your payment reception...'],
            ['Invoice Generator', 'Invoice-Generator.png', 'Create and send personalized payment links...'],
            ['Billing Management', 'Billing-Management.png', 'Simplify billing with automated system...'],
            ['Multiple Payment Options', 'Multiple-Payment-Options.png', 'Offer your customers various payment
            methods...']
            ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $box): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="box bg-white rounded-lg p-6 shadow-md hover:shadow-lg transition">
                <img src="<?php echo e(asset('assets/image/offer/'.$box[1])); ?>" class="w-40 h-40 mx-auto mb-4"
                    alt="<?php echo e($box[0]); ?>">
                <h3 class="text-xl font-semibold text-gray-800 mb-3 text-center"><?php echo e($box[0]); ?></h3>
                <p class="text-gray-600 text-center"><?php echo e($box[2]); ?></p>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Features Image Section -->
<section class=" py-16 sm:py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-16 items-center">
            <!-- Left Column: Images with overlapping, rotation, and added interactivity (click to enlarge) -->
            <div class="relative min-h-[400px] sm:min-h-[500px] lg:min-h-[600px]  overflow-hidden"> <img
                    src="<?php echo e(asset('assets/image/payment-process/payment-process-3.png')); ?>" alt="EasyCheckout Interface 1"
                    class="absolute left-0 bottom-0 w-[45%] sm:w-[40%] object-contain transform -rotate-12 transition-transform duration-500 hover:scale-105 cursor-pointer"
                    onclick="openModal(this.src, this.alt)"> <img
                    src="<?php echo e(asset('assets/image/payment-process/payment-process-2.png')); ?>" alt="EasyCheckout Interface 2"
                    class="absolute left-1/2 top-0 -translate-x-1/2 w-[45%] sm:w-[45%] object-contain transform rotate-0 z-10 transition-transform duration-500 hover:scale-105 cursor-pointer"
                    onclick="openModal(this.src, this.alt)"> <img
                    src="<?php echo e(asset('assets/image/payment-process/payment-process-1.png')); ?>" alt="EasyCheckout Interface 3"
                    class="absolute right-0 bottom-0 w-[45%] sm:w-[40%] object-contain transform rotate-12 transition-transform duration-500 hover:scale-105 cursor-pointer"
                    onclick="openModal(this.src, this.alt)"> </div>
            <!-- Right Column: Headings and Numbers with interactive accordion-style features -->
            <div class="flex flex-col gap-6 text-center lg:text-left">
                <h2 class="text-1xl md:text-2xl font-bold"> Tap into an active base of <span
                        class="text-primary">2,00,000+</span>
                    customers and eliminate re-entry of card details every
                    time they transact. </h2> <!-- Features List with Accordion Interactivity -->
                <div class="space-y-5"> <?php $easyCheckoutFeatures = [ [ 'title' => 'Better Conversions than ever',
                    'description' => 'Boost your sales with seamless checkout experiences that reduce cart
                    abandonment.', ], [ 'title' => 'Flaunt your Brand with Custom Theme', 'description' => 'Customize
                    the look and feel to match your brand identity perfectly.', ], [ 'title' => 'Easy Integration with
                    less coding', 'description' => 'Integrate quickly with minimal development effort using our APIs.',
                    ], [ 'title' => 'Saved cards across businesses', 'description' => 'Allow customers to save cards for
                    use across multiple merchants.', ], [ 'title' => 'Personalized payment experience for every user',
                    'description' => 'Tailor the payment flow based on user preferences and history.', ], [ 'title' =>
                    'Secure OTP based access to save cards', 'description' => 'Ensure security with one-time passwords
                    for card saving.', ], [ 'title' => 'Bi-lingual Support', 'description' => 'Support for multiple
                    languages to cater to diverse users.', ], ]; ?> <?php $__currentLoopData = $easyCheckoutFeatures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index =>
                    $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <div class="feature-item flex items-start gap-4 cursor-pointer"
                        onclick="toggleFeature(this)"> <span
                            class="text-xl font-bold text-gray-500"><?php echo e(str_pad($index + 1, 2, '0', STR_PAD_LEFT)); ?></span>
                        <div class="flex-1">
                            <p class="border-b border-gray-450 pb-2"><?php echo e($feature['title']); ?></p>
                            <p
                                class="feature-description hidden text-gray-600 mt-2 transition-all duration-450 ease-in-out">
                                <?php echo e($feature['description']); ?></p>
                        </div>
                    </div> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> </div>
            </div>
        </div>
    </div> <!-- Modal for Image Enlargement (made smaller) -->
    <div id="imageModal" class="fixed inset-0 bg-black bg-opacity-75 items-center justify-center z-[200] hidden"
        onclick="closeModal()">
        <div class="relative w-11/12 max-w-sm" onclick="event.stopPropagation()"> <img id="modalImage" src="" alt=""
                class="max-w-full max-h-full object-contain"> <button class="absolute top-5 right-4 text-white text-3xl"
                onclick="closeModal()">&times;</button> </div>
    </div>
</section> <!-- Counts Section -->
<section id="counts" class="py-20 sm:py-32 bg-gray-900">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div data-aos="fade-up">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Count 1 -->
                <div class="count-box bg-white rounded-xl p-6 transition-all duration-300">
                    <div class="flex items-center justify-center gap-4"> <i
                            class="bi bi-people-fill text-4xl text-primary transition-transform duration-300"></i>
                        <div class="text-left"> <span class="purecounter text-3xl font-bold text-gray-800 block"
                                data-purecounter-start="0" data-purecounter-end="1963"
                                data-purecounter-duration="2">1963</span>
                            <p class="text-gray-500 mt-1">Happy Clients</p>
                        </div>
                    </div>
                </div> <!-- Count 2 -->
                <div class="count-box bg-white rounded-xl p-6 transition-all duration-300">
                    <div class="flex items-center justify-center gap-4"> <i
                            class="bi bi-book-half text-4xl text-orange-500 transition-transform duration-300"></i>
                        <div class="text-left"> <span class="purecounter text-3xl font-bold text-gray-800 block"
                                data-purecounter-start="0" data-purecounter-end="6"
                                data-purecounter-duration="2">6</span>
                            <p class="text-gray-500 mt-1">Plans</p>
                        </div>
                    </div>
                </div> <!-- Count 3 -->
                <div class="count-box bg-white rounded-xl p-6 transition-all duration-300">
                    <div class="flex items-center justify-center gap-4"> <i
                            class="bi bi-graph-up text-4xl text-green-500 transition-transform duration-300"></i>
                        <div class="text-left"> <span class="purecounter text-3xl font-bold text-gray-800 block"
                                data-purecounter-start="0" data-purecounter-end="3287490"
                                data-purecounter-duration="2">3287490</span>
                            <p class="text-gray-500 mt-1">Total Amount Transactions</p>
                        </div>
                    </div>
                </div> <!-- Count 4 -->
                <div class="count-box bg-white rounded-xl p-6 transition-all duration-300">
                    <div class="flex items-center justify-center gap-4"> <i
                            class="bi bi-credit-card text-4xl text-pink-600 transition-transform duration-300"></i>
                        <div class="text-left"> <span class="purecounter text-3xl font-bold text-gray-800 block"
                                data-purecounter-start="0" data-purecounter-end="12"
                                data-purecounter-duration="2">12</span>
                            <p class="text-gray-500 mt-1">Supported Payment Methods</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Features Section -->
<section id="features" class="py-4 mt-20 sm:mt-24 overflow-hidden">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <header class="text-center mb-12">
            <h2 class="text-3xl font-bold text-gray-800 mb-2">Features</h2>
            <p class="text-gray-600 max-w-2xl mx-auto">Advanced capabilities for streamlined payments</p>
        </header>

        <div class="flex flex-col lg:flex-row items-center">
            <div class="w-full lg:w-1/2 mb-8 lg:mb-0">
                <img src="<?php echo e(asset('assets/image/Make-payment.gif')); ?>" class="w-full rounded-lg shadow-md"
                    alt="Features">
            </div>
            <div class="w-full lg:w-1/2 lg:pl-12 grid grid-cols-1 md:grid-cols-2 gap-6">
                <?php $__currentLoopData = [
                ['bi-speedometer2','Real-Time Processing'],
                ['bi-shield-lock','High Security'],
                ['bi-arrows-expand','Scalability'],
                ['bi-link','Seamless Integration'],
                ['bi-graph-up','Comprehensive Reporting'],
                ['bi-check-circle','Automatic Payment Verification'],
                ['bi-cash','No Transaction Fees']
                ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="feature-box bg-gray-50 rounded-lg p-4 flex items-center transition hover:bg-primary/10">
                    <i class="bi <?php echo e($f[0]); ?> text-2xl text-blue-500 mr-4"></i>
                    <h3 class="text-lg font-semibold text-gray-800"><?php echo e($f[1]); ?></h3>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>

<!-- Trusted By Section -->
<section class="bg-black py-20 mt-20 sm:mt-24 overflow-hidden">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-white mb-4">Trusted by world-class companies</h2>
            <p class="text-xl text-gray-600">These world-class teams are already using our services.</p>
        </div>
        <div class="overflow-hidden">
            <!-- Swiper -->
            <div class="swiper-container logo-carousel">
                <div class="swiper-wrapper">
                    <?php
                    $logos = [
                    asset('assets/image/svg/Trusted/beximco-vector-logo.svg'),
                    asset('assets/image/svg/Trusted/desco.svg'),
                    asset('assets/image/svg/Trusted/Grameenphone.svg'),
                    asset('assets/image/svg/Trusted/Novoair-1.svg'),
                    asset('assets/image/svg/Trusted/shohoz-vector-logo.svg'),
                    asset('assets/image/svg/Trusted/honda-300x150.png'),
                    asset('assets/image/svg/Trusted/biddanondo-300x150.png'),
                    asset('assets/image/svg/Trusted/dominos-300x150.png'),
                    asset('assets/image/svg/Trusted/lankabangla-finance-300x150.jpg'),
                    asset('assets/image/svg/Trusted/toffee-1-300x150.png'),
                    asset('assets/image/svg/Trusted/triplover-300x150.png'),
                    ];
                    ?>
                    <?php $__currentLoopData = $logos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="swiper-slide py-4">
                        <div
                            class="bg-white rounded-lg shadow-md h-32 flex items-center justify-center p-4 transition-transform duration-450 hover:scale-105 hover:shadow-xl">
                            <img src="<?php echo e($logo); ?>" alt="Client Logo" class="max-h-16 w-auto object-contain">
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Services Section -->
<section id="services" class="py-4 mt-20 sm:mt-24">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center" data-aos="fade-up">
            <header class="text-center mb-12">
                <h2 class="text-3xl font-bold text-gray-800 mb-2">Services</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">Explore our range of services</p>
            </header>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Service 1 -->
                <div class="service-box bg-blue-50 rounded-lg p-6 text-center" data-aos="fade-up" data-aos-delay="200">
                    <i class="bi bi-lightning-charge-fill text-4xl text-blue-500 mb-4"></i>
                    <h3 class="text-xl font-semibold text-gray-800 mb-3">Instant Payment</h3>
                    <p class="text-gray-600">After the customer makes the payment through Payonlinebd, it will be
                        instantly
                        added to account with automatic verification.</p>
                </div>

                <!-- Service 2 -->
                <div class="service-box bg-orange-50 rounded-lg p-6 text-center" data-aos="fade-up"
                    data-aos-delay="450">
                    <i class="bi bi-arrow-repeat text-4xl text-orange-500 mb-4"></i>
                    <h3 class="text-xl font-semibold text-gray-800 mb-3">Lifetime Updates</h3>
                    <p class="text-gray-600">Enjoy free lifetime updates with the desired service.</p>
                </div>

                <!-- Service 3 -->
                <div class="service-box bg-green-50 rounded-lg p-6 text-center" data-aos="fade-up" data-aos-delay="400">
                    <i class="bi bi-wallet text-4xl text-green-500 mb-4"></i>
                    <h3 class="text-xl font-semibold text-gray-800 mb-3">Unlimited Transactions</h3>
                    <p class="text-gray-600">Receive unlimited payments with PAY Online Bd without any fees.</p>
                </div>

                <!-- Service 4 -->
                <div class="service-box bg-red-50 rounded-lg p-6 text-center" data-aos="fade-up" data-aos-delay="500">
                    <i class="bi bi-chat-dots text-4xl text-red-500 mb-4"></i>
                    <h3 class="text-xl font-semibold text-gray-800 mb-3">24/7 Support</h3>
                    <p class="text-gray-600">Our support team is available 24/7 to solve any issues, including PAY
                        Online
                        Bd setup and usage.</p>
                </div>

                <!-- Service 5 -->
                <div class="service-box bg-purple-50 rounded-lg p-6 text-center" data-aos="fade-up"
                    data-aos-delay="600">
                    <i class="bi bi-credit-card text-4xl text-purple-500 mb-4"></i>
                    <h3 class="text-xl font-semibold text-gray-800 mb-3">Payment Processing</h3>
                    <p class="text-gray-600">Efficient and secure processing for all your payment needs, ensuring
                        seamless
                        transactions every time.</p>
                </div>

                <!-- Service 6 -->
                <div class="service-box bg-pink-50 rounded-lg p-6 text-center" data-aos="fade-up" data-aos-delay="700">
                    <i class="bi bi-shield-check text-4xl text-pink-500 mb-4"></i>
                    <h3 class="text-xl font-semibold text-gray-800 mb-3">Fraud Prevention</h3>
                    <p class="text-gray-600">Advanced fraud prevention measures to protect your business and customers
                        from
                        unauthorized activities.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Payment Channels Section -->
<section class="py-16 mt-20 sm:mt-24">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- First Inner Section -->
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 items-center">
            <!-- Heading -->
            <div class="flex items-center justify-center overflow-hidden h-32 w-full">
                <h2 class="text-2xl font-bold">Payment Channels</h2>
            </div>
            <!-- Visa -->
            <div
                class="payment-channel-logo-container flex items-center justify-center overflow-hidden transition duration-300 h-32 w-full aspect-square hover:shadow-md border-2 border-gray-300">
                <img loading="lazy" decoding="async" src="<?php echo e(asset('assets/image/svg/payment/visa.svg')); ?>" alt="Visa"
                    class="payment-channel-logo w-auto h-full object-contain p-2">
            </div>
            <!-- Mastercard -->
            <div class="payment-channel-logo-container flex items-center justify-center overflow-hidden transition duration-300 h-32 w-full aspect-square hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#ff5f00">
                <img loading="lazy" decoding="async" src="<?php echo e(asset('assets/image/svg/payment/mastercard.svg')); ?>"
                    alt="Mastercard" class="payment-channel-logo w-auto h-full object-contain p-2">
            </div>
            <!-- Amex -->
            <div class="payment-channel-logo-container flex items-center justify-center overflow-hidden transition duration-300 h-32 w-full aspect-square hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#016fd0">
                <img loading="lazy" decoding="async" src="<?php echo e(asset('assets/image/svg/payment/amex.svg')); ?>" alt="Amex"
                    class="payment-channel-logo w-auto h-full object-contain p-2">
            </div>
            <!-- Unionpay -->
            <div class="payment-channel-logo-container flex items-center justify-center overflow-hidden transition duration-300 h-32 w-full aspect-square hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#004793">
                <img loading="lazy" decoding="async" src="<?php echo e(asset('assets/image/svg/payment/unionpay.svg')); ?>"
                    alt="UnionPay" class="payment-channel-logo w-auto h-full object-contain p-2">
            </div>
            <!-- Nexus -->
            <div class="payment-channel-logo-container flex items-center justify-center overflow-hidden transition duration-300 h-32 w-full aspect-square hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#092c5c">
                <img loading="lazy" decoding="async" src="<?php echo e(asset('assets/image/svg/payment/nexus.svg')); ?>" alt="Nexus"
                    class="payment-channel-logo w-auto h-full object-contain p-2">
            </div>
            <!-- Dinersclub -->
            <div class="payment-channel-logo-container flex items-center justify-center overflow-hidden transition duration-300 h-32 w-full aspect-square hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#0079be">
                <img loading="lazy" decoding="async" src="<?php echo e(asset('assets/image/svg/payment/dinersclub.svg')); ?>"
                    alt="Diners Club" class="payment-channel-logo w-auto h-full object-contain p-2">
            </div>
            <!-- Qcash -->
            <div class="payment-channel-logo-container flex items-center justify-center overflow-hidden transition duration-300 h-32 w-full aspect-square hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#0082cb">
                <img loading="lazy" decoding="async" src="<?php echo e(asset('assets/image/svg/payment/qcash.svg')); ?>" alt="QCash"
                    class="payment-channel-logo w-auto h-full object-contain p-2">
            </div>

        </div>

        <!-- Second Inner Section -->
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 items-center mt-4">
            <!-- Bkash -->
            <div class="payment-channel-logo-container flex items-center justify-center overflow-hidden transition duration-300 h-32 w-full aspect-square hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#d12053">
                <img loading="lazy" decoding="async" src="<?php echo e(asset('assets/image/svg/payment/bkash.svg')); ?>" alt="bKash"
                    class="payment-channel-logo w-auto h-full object-contain p-2">
            </div>
            <!-- Nagad -->
            <div class="payment-channel-logo-container flex items-center justify-center overflow-hidden transition duration-300 h-32 w-full aspect-square hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#f26522">
                <img loading="lazy" decoding="async" src="<?php echo e(asset('assets/image/svg/payment/nagad.svg')); ?>" alt="Nagad"
                    class="payment-channel-logo w-auto h-full object-contain p-2">
            </div>
            <!-- Rocket -->
            <div class="payment-channel-logo-container flex items-center justify-center overflow-hidden transition duration-300 h-32 w-full aspect-square hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#8c1d96">
                <img loading="lazy" decoding="async" src="<?php echo e(asset('assets/image/svg/payment/rocket.svg')); ?>" alt="Rocket"
                    class="payment-channel-logo w-auto h-full object-contain p-2">
            </div>
            <!-- Upay -->
            <div class="payment-channel-logo-container flex items-center justify-center overflow-hidden transition duration-300 h-32 w-full aspect-square hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#00a651">
                <img loading="lazy" decoding="async" src="<?php echo e(asset('assets/image/svg/payment/upay.svg')); ?>" alt="Upay"
                    class="payment-channel-logo w-auto h-full object-contain p-2">
            </div>
            <!-- Carousel 1: Surecash / Mycash -->
            <div class="payment-channel-logo-container relative flex items-center justify-center w-full h-32 aspect-square mx-auto carousel overflow-hidden transition duration-300 hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#28c101">
                <img loading="lazy" decoding="async" alt="Surecash Logo"
                    src="<?php echo e(asset('assets/image/svg/payment/surecash.svg')); ?>"
                    class="payment-channel-logo absolute inset-0 w-full h-full object-contain transition-opacity duration-500 p-1">
                <img loading="lazy" decoding="async" alt="MyCash Logo"
                    src="<?php echo e(asset('assets/image/svg/payment/mycash.svg')); ?>"
                    class="payment-channel-logo absolute inset-0 w-full h-full object-contain transition-opacity duration-500 p-1 opacity-0">
            </div>
            <!-- Carousel 2: Mcash / Tapnpay -->
            <div class="payment-channel-logo-container relative flex items-center justify-center w-full h-32 aspect-square mx-auto carousel overflow-hidden transition duration-300 hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#58c4a2">
                <img loading="lazy" decoding="async" alt="mCash Logo"
                    src="<?php echo e(asset('assets/image/svg/payment/mcash.svg')); ?>"
                    class="payment-channel-logo absolute inset-0 w-full h-full object-contain transition-opacity duration-500 p-1">
                <img loading="lazy" decoding="async" alt="Tap'nPay Logo"
                    src="<?php echo e(asset('assets/image/svg/payment/tapnpay.svg')); ?>"
                    class="payment-channel-logo absolute inset-0 w-full h-full object-contain transition-opacity duration-500 p-1 opacity-0">
            </div>
            <!-- Carousel 3: Okwallet / Ipay -->
            <div class="payment-channel-logo-container relative flex items-center justify-center w-full h-32 aspect-square mx-auto carousel overflow-hidden transition duration-300 hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#ffe600">
                <img loading="lazy" decoding="async" alt="OK Wallet Logo"
                    src="<?php echo e(asset('assets/image/svg/payment/okwallet.svg')); ?>"
                    class="payment-channel-logo absolute inset-0 w-full h-full object-contain transition-opacity duration-500 p-1">
                <img loading="lazy" decoding="async" alt="iPay Logo"
                    src="<?php echo e(asset('assets/image/svg/payment/ipay.svg')); ?>"
                    class="payment-channel-logo absolute inset-0 w-full h-full object-contain transition-opacity duration-500 p-1 opacity-0">
            </div>
            <!-- Carousel 4: Islamicwallet / Dmoney -->
            <div class="payment-channel-logo-container relative flex items-center justify-center w-full h-32 aspect-square mx-auto carousel overflow-hidden transition duration-300 hover:shadow-md border-2 border-gray-300"
                data-hover-bg="#009000">
                <img loading="lazy" decoding="async" alt="Islamic Wallet Logo"
                    src="<?php echo e(asset('assets/image/svg/payment/islamicwallet.svg')); ?>"
                    class="payment-channel-logo absolute inset-0 w-full h-full object-contain transition-opacity duration-500 p-1">
                <img loading="lazy" decoding="async" alt="Dmoney Logo"
                    src="<?php echo e(asset('assets/image/svg/payment/dmoney.svg')); ?>"
                    class="payment-channel-logo absolute inset-0 w-full h-full object-contain transition-opacity duration-500 p-1 opacity-0">
            </div>
        </div>
    </div>
</section>


<!-- Testimonials Section -->
<section class="py-40">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div>
            <div class="text-center mb-12 lg:mb-20">
                <h2 class="text-3xl font-bold text-gray-800 mb-4">What Our Customers Say</h2>
                <p class="text-xl text-gray-600">Hear from businesses that have transformed their payment processes with
                    HilnexPay.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Testimonial 1 -->
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex items-center mb-4 transition-transform hover:scale-105">
                        <div class="w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center mr-4">
                            <i class="fas fa-user text-primary"></i>
                        </div>
                        <div>
                            <h4 class="font-bold text-gray-800">Sarah Johnson</h4>
                            <p class="text-gray-600 text-sm">CEO, TechSolutions</p>
                        </div>
                    </div>
                    <p class="text-gray-600 italic">"HilnexPay has revolutionized how we handle payments. The automation
                        features have saved us countless hours."</p>
                </div>

                <!-- Testimonial 2 -->
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex items-center mb-4 transition-transform hover:scale-105">
                        <div class="w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center mr-4">
                            <i class="fas fa-user text-primary"></i>
                        </div>
                        <div>
                            <h4 class="font-bold text-gray-800">Michael Chen</h4>
                            <p class="text-gray-600 text-sm">Founder, RetailPro</p>
                        </div>
                    </div>
                    <p class="text-gray-600 italic">"The integration was seamless and the customer support has been
                        exceptional. Highly recommended!"</p>
                </div>

                <!-- Testimonial 3 -->
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex items-center mb-4 transition-transform hover:scale-105">
                        <div class="w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center mr-4">
                            <i class="fas fa-user text-primary"></i>
                        </div>
                        <div>
                            <h4 class="font-bold text-gray-800">Emily Rodriguez</h4>
                            <p class="text-gray-600 text-sm">Finance Manager, GlobalTech</p>
                        </div>
                    </div>
                    <p class="text-gray-600 italic">"Real-time tracking and multiple gateway support have made our
                        payment
                        processing so much more efficient."</p>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- CTA Section -->
<section class="py-40 bg-black text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <div>
            <h2 class="text-3xl font-bold mb-4">Ready to Streamline Your Payments?</h2>
            <p class="text-xl mb-8 max-w-2xl mx-auto">Join thousands of businesses that trust HilnexPay for their
                payment
                automation needs.</p>
            <a href="<?php echo e(route('register')); ?>"
                class="btn btn-primary btn-lg no-underline btn-get-started px-6 py-1 sm:px-8 sm:py-2 shadow-none inline-flex items-center justify-center text-center">Get
                Started</a>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- AOS Library JS for scroll animations -->
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<!-- SwiperJS for the logo carousel (Trusted By Section) -->
<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize AOS (Animate On Scroll) library
    AOS.init({
        duration: 800,
        easing: 'ease-in-out',
        once: true
    });

    // Initialize PureCounter for the animated numbers in the "Counts Section"
    new PureCounter();

    // Initialize Swiper
    new Swiper('.logo-carousel', {
        loop: true,
        autoplay: {
            delay: 1,
            disableOnInteraction: false,
        },
        slidesPerView: 'auto',
        speed: 5000,
        grabCursor: true,
        mousewheelControl: true,
        keyboardControl: true,
        breakpoints: {
            320: {
                slidesPerView: 2,
                spaceBetween: 40
            },
            768: {
                slidesPerView: 4,
                spaceBetween: 40
            },
            1024: {
                slidesPerView: 5,
                spaceBetween: 50
            }
        }
    });
});

// Smooth scrolling for anchor links (e.g., in the navigation)
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function(e) {
        e.preventDefault();

        const targetId = this.getAttribute('href');
        if (targetId === '#') return;

        const targetElement = document.querySelector(targetId);
        if (targetElement) {
            window.scrollTo({
                top: targetElement.offsetTop - 80, // Adjust for nav height
                behavior: 'smooth'
            });
        }
    });
});

// Counter animation for the "Years of experience" in the "Text Section"
function animateOdometer() {
    const counterContainer = document.getElementById('odometer-counter');
    if (!counterContainer) return;

    const targetNumber = 15;
    const duration = 2000; // Animation duration in ms
    const digits = String(targetNumber).split('');

    counterContainer.innerHTML = ''; // Clear previous content

    digits.forEach((digit, index) => {
        const digitValue = parseInt(digit, 10);
        const digitWrapper = document.createElement('div');
        digitWrapper.className = 'relative h-[1em] overflow-hidden';

        const numberStrip = document.createElement('div');
        numberStrip.className = 'flex flex-col transition-transform duration-[2000ms] ease-out';
        numberStrip.style.transform = 'translateY(0)';

        for (let i = 0; i <= 9; i++) {
            const numElement = document.createElement('span');
            numElement.textContent = i;
            numberStrip.appendChild(numElement);
        }

        digitWrapper.appendChild(numberStrip);
        counterContainer.appendChild(digitWrapper);

        // Delay each digit's animation slightly for a staggered effect
        setTimeout(() => {
            numberStrip.style.transform = `translateY(-${digitValue * 10}%)`;
        }, 100 + index * 150);
    });
}

// Trigger the animation when the element is in view
const observer = new IntersectionObserver((entries) => {
    if (entries[0].isIntersecting) {
        animateOdometer();
        observer.disconnect(); // Animate only once
    }
}, {
    threshold: 0.5
});
const odometerElement = document.getElementById('odometer-counter');
if (odometerElement) {
    observer.observe(odometerElement);
}

// Accordion functionality for the "Features Image Section"
function toggleFeature(clickedElement) {
    const allFeatureItems = document.querySelectorAll('.feature-item');
    const currentDescription = clickedElement.querySelector('.feature-description');
    const isCurrentlyOpen = !currentDescription.classList.contains('hidden');

    // Close all other feature descriptions
    allFeatureItems.forEach(item => {
        if (item !== clickedElement) {
            const description = item.querySelector('.feature-description');
            if (description) {
                description.classList.add('hidden');
            }
        }
    });

    // Toggle the clicked one
    if (currentDescription) {
        currentDescription.classList.toggle('hidden');
    }
}

// Modal functionality for enlarging images in the "Features Image Section"
function openModal(src, alt) {
    const modal = document.getElementById('imageModal');
    const modalImg = document.getElementById('modalImage');
    modalImg.src = src;
    modalImg.alt = alt;
    modal.classList.add('flex');
    modal.classList.remove('hidden');
}

function closeModal() {
    const modal = document.getElementById('imageModal');
    modal.classList.remove('flex');
    modal.classList.add('hidden');
}

// Image carousel/fader for the "Payment Channels Section"
document.querySelectorAll('.carousel').forEach(carousel => {
    const images = carousel.querySelectorAll('img');
    let currentIndex = 0;
    setInterval(() => {
        images[currentIndex].classList.add('opacity-0');
        currentIndex = (currentIndex + 1) % images.length;
        images[currentIndex].classList.remove('opacity-0');
    }, 3800);
});

// Payment Channels glow animation
const logos = document.querySelectorAll('.payment-channel-logo');
const logoContainers = document.querySelectorAll('.payment-channel-logo-container');

function randomGlow() {
    // Reset all
    logos.forEach(logo => logo.classList.remove('glow'));

    const numToGlow = Math.floor(Math.random() * 3) + 1; // 1, 2, or 3
    const availableLogos = Array.from(logos);

    for (let i = 0; i < numToGlow; i++) {
        if (availableLogos.length === 0) break;
        const randomIndex = Math.floor(Math.random() * availableLogos.length);
        const logoToGlow = availableLogos.splice(randomIndex, 1)[0];
        logoToGlow.classList.add('glow');
    }
}

setInterval(randomGlow, 2000); // Change glow every 2 seconds

logoContainers.forEach(container => {
    const originalBg = container.style.backgroundColor;
    container.addEventListener('mouseenter', () => {
        const hoverColor = container.dataset.hoverBg;
        if (hoverColor) {
            container.style.backgroundColor = `${hoverColor}1A`; // 10% opacity
        }
    });
    container.addEventListener('mouseleave', () => {
        container.style.backgroundColor = originalBg;
    });
});

// Ensure background video plays consistently
const backgroundVideo = document.getElementById('background-video');
if (backgroundVideo) {
    // Attempt to play on load
    backgroundVideo.play().catch(error => {
        console.log("Video autoplay was prevented:", error);
    });

    // Add an event listener to play the video if it gets paused
    backgroundVideo.addEventListener('pause', () => {
        backgroundVideo.play();
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\hilnexpay\resources\views/frontend/home.blade.php ENDPATH**/ ?>