
<?php $__env->startSection('title', 'View Invoice'); ?>
<?php ($prefix = auth()->user()->role === 'admin' ? 'admin.' : 'user.'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 sm:px-8 py-8">
    <div class="max-w-4xl mx-auto bg-white dark:bg-gray-800 rounded-lg shadow-lg overflow-hidden">
        <div class="p-6 border-b border-gray-200 dark:border-gray-700 flex justify-between items-center">
            <div>
                <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Invoice #<?php echo e($invoice->invoice_number); ?></h2>
                <p class="text-sm text-gray-500 dark:text-gray-400">Created on: <?php echo e($invoice->created_at->format('F d, Y')); ?></p>
            </div>
            <div class="flex items-center space-x-2">
                <a href="<?php echo e(route($prefix . 'invoices.index')); ?>" class="text-sm font-medium text-indigo-600 dark:text-indigo-400 hover:underline">&larr; Back to Invoices</a>
                <a href="<?php echo e(route($prefix . 'invoices.edit', $invoice->id)); ?>" class="inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-medium rounded-md shadow-sm text-white bg-yellow-600 hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500">
                    <i class="fas fa-edit -ml-0.5 mr-2"></i> Edit
                </a>
            </div>
        </div>

        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Left Column -->
                <div>
                    <h3 class="text-lg font-semibold text-gray-800 dark:text-gray-200 mb-4">Billed To</h3>
                    <div class="text-gray-700 dark:text-gray-300 space-y-1">
                        <p class="font-bold"><?php echo e($invoice->customer_name); ?></p>
                        <p><?php echo e($invoice->customer_email); ?></p>
                        <p><?php echo e($invoice->customer_number); ?></p>
                        <p class="whitespace-pre-line"><?php echo e($invoice->customer_address); ?></p>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="text-left md:text-right">
                    <h3 class="text-lg font-semibold text-gray-800 dark:text-gray-200 mb-4">Payment Details</h3>
                    <div class="text-gray-700 dark:text-gray-300 space-y-1">
                        <p><span class="font-semibold">Brand:</span> <?php echo e($invoice->brand->name); ?></p>
                        <p><span class="font-semibold">Due Date:</span> <?php echo e($invoice->due_date->format('F d, Y')); ?></p>
                        <p><span class="font-semibold">Status:</span>
                            <?php if($invoice->status): ?>
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300">Active</span>
                            <?php else: ?>
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300">Inactive</span>
                            <?php endif; ?>
                        </p>
                        <p><span class="font-semibold">Payment Status:</span>
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                <?php if($invoice->payment_status == 'paid'): ?> bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300 <?php endif; ?>
                                <?php if($invoice->payment_status == 'pending'): ?> bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300 <?php endif; ?>
                                <?php if($invoice->payment_status == 'unpaid'): ?> bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300 <?php endif; ?>">
                                <?php echo e(ucfirst($invoice->payment_status)); ?>

                            </span>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Description -->
            <?php if($invoice->description): ?>
            <div class="mt-8">
                <h3 class="text-lg font-semibold text-gray-800 dark:text-gray-200 mb-2">Description</h3>
                <p class="text-gray-600 dark:text-gray-400"><?php echo e($invoice->description); ?></p>
            </div>
            <?php endif; ?>

            <!-- Invoice Total -->
            <div class="mt-8 border-t border-gray-200 dark:border-gray-700 pt-6">
                <div class="flex justify-end">
                    <div class="w-full max-w-xs">
                        <div class="flex justify-between text-gray-700 dark:text-gray-300">
                            <span>Subtotal</span>
                            <span><?php echo e(number_format($invoice->amount, 2)); ?> BDT</span>
                        </div>
                        <div class="flex justify-between text-gray-700 dark:text-gray-300 mt-2">
                            <span>Tax (0%)</span>
                            <span>0.00 BDT</span>
                        </div>
                        <div class="mt-4 pt-4 border-t border-gray-200 dark:border-gray-700">
                            <div class="flex justify-between font-bold text-lg text-gray-900 dark:text-white">
                                <span>Total</span>
                                <span><?php echo e(number_format($invoice->amount, 2)); ?> BDT</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\hilnexpay\resources\views/dashboard/invoices-show.blade.php ENDPATH**/ ?>