<?php $__env->startSection('title', 'Pricing - HilnexPay'); ?>

<?php $__env->startPush('styles'); ?>
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <style>
        .pricing-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .pricing-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 25px -5px rgba(79, 70, 229, 0.1), 0 10px 10px -5px rgba(79, 70, 229, 0.05);
        }

        .faq-item {
            transition: background-color 0.2s ease;
        }

        .faq-question.open svg {
            transform: rotate(180deg);
        }

        .faq-answer {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.5s ease-in-out, padding 0.5s ease-in-out;
        }

        .faq-answer.open {
            max-height: 200px; /* Adjust as needed */
            padding-top: 1rem;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Header -->
    <section class="bg-gradient-to-r from-primary to-secondary text-white py-16 sm:py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center" data-aos="fade-up">
            <h1 class="text-4xl md:text-5xl font-extrabold">Flexible Pricing for Every Business</h1>
            <p class="mt-4 text-lg md:text-xl text-gray-200 max-w-3xl mx-auto">Choose the perfect plan to automate your payments and grow your business. No hidden fees, no surprises.</p>
        </div>
    </section>

    <!-- Pricing Plans Section -->
    <section class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Plan 1: Starter -->
                <div class="pricing-card bg-white rounded-lg shadow-lg p-8 flex flex-col" data-aos="fade-up" data-aos-delay="100">
                    <h3 class="text-2xl font-bold text-gray-800 mb-4">Starter</h3>
                    <p class="text-gray-600 mb-6 flex-grow">For individuals and small businesses just getting started.</p>
                    <div class="mb-6">
                        <span class="text-4xl font-extrabold text-gray-900">$29</span>
                        <span class="text-lg font-medium text-gray-500">/month</span>
                    </div>
                    <ul class="space-y-4 text-gray-600 mb-8">
                        <li class="flex items-center"><i class="fas fa-check-circle text-green-500 mr-2"></i>Up to 500 transactions/month</li>
                        <li class="flex items-center"><i class="fas fa-check-circle text-green-500 mr-2"></i>Basic analytics</li>
                        <li class="flex items-center"><i class="fas fa-check-circle text-green-500 mr-2"></i>Email support</li>
                    </ul>
                    <a href="#" class="btn btn-secondary w-full mt-auto">Choose Plan</a>
                </div>

                <!-- Plan 2: Business (Recommended) -->
                <div class="pricing-card bg-primary text-primary-foreground rounded-lg shadow-2xl p-8 flex flex-col relative" data-aos="fade-up" data-aos-delay="200">
                    <span class="absolute top-0 -translate-y-1/2 bg-secondary text-secondary-foreground text-xs font-bold px-3 py-1 rounded-full uppercase">Most Popular</span>
                    <h3 class="text-2xl font-bold mb-4">Business</h3>
                    <p class="mb-6 flex-grow">For growing businesses that need more power and flexibility.</p>
                    <div class="mb-6">
                        <span class="text-4xl font-extrabold">$79</span>
                        <span class="text-lg font-medium opacity-80">/month</span>
                    </div>
                    <ul class="space-y-4 mb-8">
                        <li class="flex items-center"><i class="fas fa-check-circle text-green-300 mr-2"></i>Up to 5000 transactions/month</li>
                        <li class="flex items-center"><i class="fas fa-check-circle text-green-300 mr-2"></i>Advanced analytics</li>
                        <li class="flex items-center"><i class="fas fa-check-circle text-green-300 mr-2"></i>Priority email & chat support</li>
                        <li class="flex items-center"><i class="fas fa-check-circle text-green-300 mr-2"></i>API access</li>
                    </ul>
                    <a href="#" class="btn btn-light w-full mt-auto">Choose Plan</a>
                </div>

                <!-- Plan 3: Enterprise -->
                <div class="pricing-card bg-white rounded-lg shadow-lg p-8 flex flex-col" data-aos="fade-up" data-aos-delay="300">
                    <h3 class="text-2xl font-bold text-gray-800 mb-4">Enterprise</h3>
                    <p class="text-gray-600 mb-6 flex-grow">For large-scale businesses with custom requirements.</p>
                    <div class="mb-6">
                        <span class="text-4xl font-extrabold text-gray-900">Custom</span>
                    </div>
                    <ul class="space-y-4 text-gray-600 mb-8">
                        <li class="flex items-center"><i class="fas fa-check-circle text-green-500 mr-2"></i>Unlimited transactions</li>
                        <li class="flex items-center"><i class="fas fa-check-circle text-green-500 mr-2"></i>Dedicated account manager</li>
                        <li class="flex items-center"><i class="fas fa-check-circle text-green-500 mr-2"></i>24/7 phone support</li>
                        <li class="flex items-center"><i class="fas fa-check-circle text-green-500 mr-2"></i>Custom integrations</li>
                    </ul>
                    <a href="<?php echo e(url('/contact')); ?>" class="btn btn-secondary w-full mt-auto">Contact Us</a>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="py-20 bg-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl font-bold text-gray-800">Frequently Asked Questions</h2>
                <p class="mt-4 text-lg text-gray-600">Have questions? We've got answers.</p>
            </div>
            <div class="space-y-4" data-aos="fade-up" data-aos-delay="100">
                <?php
                    $faqs = [
                        ['q' => 'Can I change my plan later?', 'a' => 'Yes, you can upgrade or downgrade your plan at any time from your account dashboard.'],
                        ['q' => 'Is there a free trial?', 'a' => 'We offer a 14-day free trial for our Business plan. No credit card required.'],
                        ['q' => 'What payment methods do you accept?', 'a' => 'We accept all major credit cards, as well as payments via PayPal and bank transfer.'],
                        ['q' => 'Are there any setup fees?', 'a' => 'No, there are no setup fees on any of our plans.'],
                    ];
                ?>
                <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="faq-item bg-gray-50 rounded-lg">
                    <button class="faq-question flex justify-between items-center w-full p-6 text-left text-lg font-medium text-gray-800">
                        <span><?php echo e($faq['q']); ?></span>
                        <svg class="w-6 h-6 text-gray-500 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                    </button>
                    <div class="faq-answer px-6 text-gray-600">
                        <p><?php echo e($faq['a']); ?></p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            AOS.init({
                duration: 800,
                easing: 'ease-in-out',
                once: true
            });

            const faqItems = document.querySelectorAll('.faq-item');
            faqItems.forEach(item => {
                const question = item.querySelector('.faq-question');
                const answer = item.querySelector('.faq-answer');

                question.addEventListener('click', () => {
                    const isOpen = answer.classList.contains('open');

                    // Close all answers
                    document.querySelectorAll('.faq-answer').forEach(ans => {
                        ans.classList.remove('open');
                        ans.previousElementSibling.classList.remove('open');
                    });

                    // Open the clicked one if it was closed
                    if (!isOpen) {
                        answer.classList.add('open');
                        question.classList.add('open');
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\hilnexpay\resources\views/frontend/pricing.blade.php ENDPATH**/ ?>