<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'Laravel')); ?></title>

        <!-- Favicon -->
        <link rel="icon" href="<?php echo e(asset('assets/image/Fav-Icon-black.png')); ?>" type="image/png">

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

        <!-- Font Awesome -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

        <?php echo $__env->yieldPushContent('styles'); ?>
        <style>
            .form-input {
                border: 1px solid #ddd;
                border-radius: 6px;
                padding: 0.75rem 1rem;
                width: 100%;
                transition: border-color 0.2s, box-shadow 0.2s;
            }
            .form-input:focus {
                border-color: #4f46e5;
                box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.2);
                outline: none;
            }
            .form-input-icon {
                position: absolute;
                left: 0.75rem;
                top: 50%;
                transform: translateY(-50%);
                color: #9ca3af; /* gray-400 */
            }
            .form-input-with-icon {
                padding-left: 2.5rem;
            }
            .password-toggle {
                cursor: pointer;
            }
            .btn-primary-login {
                background-color: black; /* indigo-600 */
                color: white;
                font-weight: bold;
                padding: 0.75rem;
                border-radius: 8px;
                width: 100%;
                transition: all 0.3s ease;
                box-shadow: 0 4px 6px rgba(79, 70, 229, 0.1);
            }
            .btn-primary-login:hover {
                background-color: #4338ca; /* indigo-700 */
                transform: translateY(-2px);
                box-shadow: 0 7px 14px rgba(79, 70, 229, 0.2);
            }
            .btn-secondary-register {
                background-color: #16a34a; /* green-600 */
                color: white;
                font-weight: bold;
                padding: 0.75rem;
                border-radius: 8px;
                transition: all 0.3s ease;
                box-shadow: 0 4px 6px rgba(22, 163, 74, 0.1);
                width: 100%;
            }
            .btn-secondary-register:hover {
                background-color: #15803d; /* green-700 */
                transform: translateY(-2px);
                box-shadow: 0 7px 14px rgba(22, 163, 74, 0.2);
            }
            .btn-primary-register {
                background-color: #16a34a; /* green-600 */
                color: white;
                font-weight: bold;
                padding: 0.75rem;
                border-radius: 6px;
                width: 100%;
                transition: background-color 0.3s;
            }
        </style>
    </head>
    <body class="font-sans text-gray-900 antialiased">
            <div id="particles-js1"></div>

        <div class="min-h-screen flex flex-col sm:justify-center items-center p-4 sm:p-6 bg-gradient-to-br from-gray-50 to-indigo-100 dark:from-gray-800 dark:to-gray-900">
            <div class="w-full max-w-4xl bg-white dark:bg-gray-800 shadow-2xl rounded-xl overflow-hidden flex flex-col md:flex-row">
                <!-- Left Side: Brand Info -->
                <div class="w-full md:w-1/2 p-8 bg-black text-white hidden md:flex flex-col justify-center items-center text-center">
                    <a href="<?php echo e(url('/')); ?>">
                        <img src="<?php echo e(asset('assets/image/hilnex-logo3.png')); ?>" alt="HilnexPay Logo" class="h-16 mb-6">
                    </a>
                    <h1 class="text-3xl font-bold mb-3">Welcome to HilnexPay</h1>
                    <p class="text-indigo-200">
                        Your seamless and secure payment automation platform.
                    </p>
                </div>
    
                <!-- Right Side: Form Content -->
                <div class="w-full md:w-1/2 flex justify-center items-center p-6 sm:p-8">
                    
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
        <?php echo $__env->yieldPushContent('scripts'); ?>
    <script>
        particlesJS('particles-js1', {
            "particles": {
                "number": {
                    "value": 40,
                    "density": {
                        "enable": true,
                        "value_area": 800
                    }
                },
                "color": {
                    "value": "#3928D1"
                },
                "shape": {
                    "type": "polygon",
                    "stroke": {
                        "width": 0,
                        "color": "#000000"
                    },
                    "polygon": {
                        "nb_sides": 6
                    }
                },
                "opacity": {
                    "value": 0.5,
                    "random": false,
                    "anim": {
                        "enable": false,
                        "speed": 1,
                        "opacity_min": 0.1,
                        "sync": false
                    }
                },
                "size": {
                    "value": 1,
                    "random": true,
                    "anim": {
                        "enable": false,
                        "speed": 40,
                        "size_min": 0.1,
                        "sync": false
                    }
                },
                "line_linked": {
                    "enable": true,
                    "distance": 300,
                    "color": "#FFFFFF",
                    "opacity": 0.4,
                    "width": 1
                },
                "move": {
                    "enable": true,
                    "speed": 5,
                    "direction": "none",
                    "random": false,
                    "straight": false,
                    "out_mode": "out",
                    "bounce": false,
                    "attract": {
                        "enable": false,
                        "rotateX": 600,
                        "rotateY": 1200
                    }
                }
            },
            "interactivity": {
                "detect_on": "canvas",
                "events": {
                    "onhover": {
                        "enable": true,
                        "mode": "repulse"
                    },
                    "onclick": {
                        "enable": true,
                        "mode": "push"
                    },
                    "resize": true
                },
                "modes": {
                    "grab": {
                        "distance": 400,
                        "line_linked": {
                            "opacity": 1
                        }
                    },
                    "bubble": {
                        "distance": 400,
                        "size": 40,
                        "duration": 2,
                        "opacity": 8,
                        "speed": 3
                    },
                    "repulse": {
                        "distance": 200,
                        "duration": 0.4
                    },
                    "push": {
                        "particles_nb": 4
                    },
                    "remove": {
                        "particles_nb": 2
                    }
                }
            },
            "retina_detect": true
        });
    </script>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\hilnexpay\resources\views/layouts/guest.blade.php ENDPATH**/ ?>