
<?php $__env->startSection('title', 'Invoice #' . $invoice->invoice_number); ?>

<?php $__env->startPush('styles'); ?>
<style>
    @media print {
        .no-print, #sidebar, header.bg-white {
            display: none !important;
        }
        main {
            padding: 0 !important;
            margin: 0 !important;
        }
        body {
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
            background-color: #fff !important;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-100 dark:bg-gray-900 p-4 md:p-8">
    <div class="max-w-4xl mx-auto bg-white dark:bg-gray-800 rounded-lg shadow-lg overflow-hidden">
        <!-- Header -->
        <div class="bg-gradient-to-r from-primary to-secondary text-white py-10 sm:py-20">
            <h1 class="text-2xl font-bold text-center">INVOICE</h1>
        </div>

        <!-- Top Section -->
        <div class="p-6 border-b border-gray-200">
            <div class="flex flex-col md:flex-row justify-between items-start md:items-center">
                <!-- Brand Info -->
                <div class="flex items-center mb-4 md:mb-0">
                    <?php if($invoice->brand->brand_logo): ?>
                    <img class="rounded border border-gray-300 dark:border-gray-600"
                         src="<?php echo e(asset('storage/' . $invoice->brand->brand_logo)); ?>"
                         width="60px" alt="<?php echo e($invoice->brand->name); ?> Logo">
                    <?php endif; ?>
                    <h4 class="ml-3 text-lg font-semibold text-gray-900 dark:text-white"><?php echo e($invoice->brand->name); ?></h4>
                </div>

                <!-- Invoice Status -->
                <div class="text-center md:text-right">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Payment Status:
                        <span class="
                            <?php if($invoice->payment_status == 'paid'): ?> text-green-500 <?php endif; ?>
                            <?php if($invoice->payment_status == 'pending'): ?> text-yellow-500 <?php endif; ?>
                            <?php if($invoice->payment_status == 'unpaid'): ?> text-red-500 <?php endif; ?>
                        "><?php echo e(ucfirst($invoice->payment_status)); ?></span>
                    </h3>
                    <?php if($invoice->transaction): ?>
                        <p class="text-gray-600 dark:text-gray-400">TrxId: <?php echo e($invoice->transaction->trx_id); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Invoice Details -->
        <div class="p-6 border-b border-gray-200">
            <h2 class="text-xl font-semibold mb-4 text-gray-800 dark:text-white">Invoice Details</h2>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        <tr>
                            <th class="px-4 py-3 bg-gray-50 dark:bg-gray-700/50 text-left text-sm font-medium text-gray-700 dark:text-gray-300">INVOICE</th>
                            <td class="px-4 py-3 text-sm text-gray-900 dark:text-gray-200">#<?php echo e($invoice->invoice_number); ?></td>
                        </tr>
                        <tr>
                            <th class="px-4 py-3 bg-gray-50 dark:bg-gray-700/50 text-left text-sm font-medium text-gray-700 dark:text-gray-300">Creation Date</th>
                            <td class="px-4 py-3 text-sm text-gray-900 dark:text-gray-200"><?php echo e($invoice->created_at->format('d F, Y h:i:s A')); ?></td>
                        </tr>
                        <tr>
                            <th class="px-4 py-3 bg-gray-50 dark:bg-gray-700/50 text-left text-sm font-medium text-gray-700 dark:text-gray-300">Pay to</th>
                            <td class="px-4 py-3 text-sm text-gray-900 dark:text-gray-200"><?php echo e($invoice->brand->name); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Customer Information -->
        <div class="p-6 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-xl font-semibold mb-4 text-gray-800 dark:text-white">Customer Information</h2>
            <div class="space-y-2 text-gray-800 dark:text-gray-200">
                <p><strong class="text-gray-700 dark:text-gray-300">Name: </strong><?php echo e($invoice->customer_name); ?></p>
                <?php if($invoice->customer_number): ?>
                <p><strong class="text-gray-700 dark:text-gray-300">Number: </strong><?php echo e($invoice->customer_number); ?></p>
                <?php endif; ?>
                <?php if($invoice->customer_email): ?>
                <p><strong class="text-gray-700 dark:text-gray-300">Email: </strong><?php echo e($invoice->customer_email); ?></p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Invoice Items -->
        <div class="p-6">
            <h2 class="text-xl font-semibold mb-4 text-gray-800 dark:text-white">Invoice Items</h2>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead>
                        <tr>
                            <th class="px-4 py-3 bg-gray-50 text-left text-sm font-medium text-gray-700">Description</th>
                            <th class="px-4 py-3 bg-gray-50 text-left text-sm font-medium text-gray-700">Qty</th>
                            <th class="px-4 py-3 bg-gray-50 text-left text-sm font-medium text-gray-700">Price</th>
                            <th class="px-4 py-3 bg-gray-50 text-left text-sm font-medium text-gray-700">Amount</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        <tr>
                            <td class="px-4 py-3 text-sm text-gray-900 dark:text-gray-200"><?php echo e($invoice->description ?: 'Service/Product Charge'); ?></td>
                            <td class="px-4 py-3 text-sm text-gray-900 dark:text-gray-200">1</td>
                            <td class="px-4 py-3 text-sm text-gray-900 dark:text-gray-200"><?php echo e(number_format($invoice->amount, 2)); ?>৳</td>
                            <td class="px-4 py-3 text-sm text-gray-900 dark:text-gray-200"><?php echo e(number_format($invoice->amount, 2)); ?>৳</td>
                        </tr>
                        <tr class="bg-gray-50 dark:bg-gray-700/50 font-semibold">
                            <td class="px-4 py-3 text-sm text-gray-900 dark:text-gray-200" colspan="3">Total Price</td>
                            <td class="px-4 py-3 text-sm text-gray-900 dark:text-gray-200"><?php echo e(number_format($invoice->amount, 2)); ?>৳</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="p-6 border-t border-gray-200 dark:border-gray-700 no-print">
            <div class="flex justify-center items-center space-x-4">
                
                <?php if($invoice->payment_status == 'unpaid'): ?>
                    <?php
                        // Manually construct the localized URL for the payment page
                        $paymentUrl = route('payment', ['brand_key' => $invoice->brand->brand_key, 'amount' => $invoice->amount, 'invoice_number' => $invoice->invoice_number], false); // `false` for relative URL
                        $localizedPaymentUrl = \Mcamara\LaravelLocalization\Facades\LaravelLocalization::getLocalizedURL(app()->getLocale(), url($paymentUrl));
                    ?>
                    <a href="<?php echo e($localizedPaymentUrl); ?>"
                       class="action-btn bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-6 rounded-md transition duration-200">
                        Pay Now
                    </a>
                <?php endif; ?>
                <button class="action-btn bg-gray-500 hover:bg-gray-600 text-white font-medium py-2 px-6 rounded-md transition duration-200" onclick="window.print()">
                    Print
                </button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.invoices.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\hilnexpay\resources\views/dashboard/public-show.blade.php ENDPATH**/ ?>