<?php $__env->startSection('title', 'Affiliates'); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .cursor-pointer {
            cursor: pointer;
        }

        .avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            border: 2px solid #ccc;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <section class="p-4 md:p-6">
        <div class="max-w-4xl mx-auto">
            <!-- Referral Programs Card -->
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md overflow-hidden mb-4">
                <div class="bg-blue-50 dark:bg-gray-700/50 p-4 border-b border-blue-100 dark:border-gray-700">
                    <h2 class="text-blue-500 dark:text-blue-400 font-semibold">Referral Programs</h2>
                </div>
                <div class="p-4">
                    <!-- Referral Link Section -->
                    <div class="mb-4">
                        <label class="block text-gray-700 dark:text-gray-300 mb-2">Your Referral Link</label>
                        <div class="flex">
                            <input readonly type="text"
                                class="flex-grow px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-l-md bg-gray-50 dark:bg-gray-900 text-gray-900 dark:text-gray-300 text-to-clipboard"
                                value="<?php echo e(route('register.referral', $user->referral_code)); ?>">
                            <button
                                class="bg-black text-white px-4 py-2 rounded-r-md my-copy-btn cursor-pointer  transition-colors">
                                <i class="fas fa-copy"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Parent User Info -->
                    <div>
                        <h6 class="font-medium text-gray-900 dark:text-gray-100">Your Parent User :
                            <?php if($user->parent): ?>
                                <span class="text-green-600 dark:text-green-400"><?php echo e($user->parent->name); ?>

                                    (<?php echo e($user->parent->email); ?>)</span>
                            <?php else: ?>
                                <span class="text-gray-600 dark:text-gray-400">No Parent User Found</span>
                            <?php endif; ?>
                        </h6>
                    </div>
                </div>
            </div>

            <!-- User Tree Card -->
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md overflow-hidden">
                <div class="p-4 text-center">
                    <table class="mx-auto">
                        <tbody>
                            <tr>
                                <td>
                                    <a href="#" class="block">
                                        <img src="<?php echo e($user->avatar_url); ?>" alt="Avatar" class="avatar mx-auto">
                                        <div class="mt-2 text-blue-500 dark:text-blue-400"><?php echo e($user->email); ?></div>
                                    </a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

    <!-- Toast Notification (hidden by default) -->
    <div id="toast" class="hidden fixed bottom-4 right-4 bg-green-500 text-white px-4 py-2 rounded-md shadow-lg z-50">
        Referral Link Copied Successfully
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Copy to clipboard functionality
            document.querySelector('.my-copy-btn').addEventListener('click', function() {
                const inputElement = document.querySelector('.text-to-clipboard');
                const value = inputElement.value;

                navigator.clipboard.writeText(value).then(function() {
                    const toast = document.getElementById('toast');
                    toast.classList.remove('hidden');
                    setTimeout(function() {
                        toast.classList.add('hidden');
                    }, 3000);
                }).catch(function(err) {
                    console.error('Failed to copy: ', err);
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\hilnexpay\resources\views/dashboard/affiliates.blade.php ENDPATH**/ ?>