<?php $__env->startSection('title', 'About Us - HilnexPay'); ?>
<?php $__env->startPush('styles'); ?>
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <style>
        .team-member-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .team-member-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Header -->
    <section class="bg-gradient-to-r from-primary to-secondary text-white py-16 sm:py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center" data-aos="fade-up">
            <h1 class="text-3xl sm:text-4xl md:text-5xl font-extrabold">About HilnexPay</h1>
            <p class="mt-4 text-lg md:text-xl text-gray-200 max-w-3xl mx-auto">Learn more about our mission, our team,
                and what drives us to build the future of payment automation.</p>
        </div>
    </section>

    <!-- Our Mission Section -->
    <section class="py-16 sm:py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
                <div data-aos="fade-right">
                    <h2 class="text-3xl font-bold text-gray-800 mb-4">Our Mission</h2>
                    <p class="text-gray-600 text-lg mb-4">
                        At HilnexPay, our mission is to simplify the complexity of online payments. We believe that every
                        business, big or small, deserves access to powerful, reliable, and easy-to-use payment solutions.
                    </p>
                    <p class="text-gray-600 text-lg">
                        We are dedicated to providing a seamless and secure platform that empowers businesses to grow,
                        innovate, and thrive in the digital economy. Our goal is to be the one-stop platform for all your
                        payment automation needs.
                    </p>
                </div>
                <div class="mt-8 md:mt-0" data-aos="fade-left">
                    <img src="https://images.unsplash.com/photo-1521737604893-d14cc237f11d?ixlib=rb-4.0.3&auto=format&fit=crop&w=1170&q=80"
                        alt="Our Team" class="rounded-lg shadow-xl">
                </div>
            </div>
        </div>
    </section>

    <!-- Our Values Section -->
    <section class="py-16 sm:py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl font-bold text-gray-800">Our Core Values</h2>
                <p class="mt-4 text-lg text-gray-600">The principles that guide our work and culture.</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="text-center p-6" data-aos="fade-up" data-aos-delay="100">
                    <div
                        class="w-20 h-20 mx-auto flex items-center justify-center bg-primary-100 text-primary-600 rounded-full mb-4">
                        <i class="fas fa-users text-3xl"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-800 mb-2">Customer First</h3>
                    <p class="text-gray-600">We succeed when our customers succeed. We are committed to understanding their
                        needs and delivering exceptional value.</p>
                </div>
                <div class="text-center p-6" data-aos="fade-up" data-aos-delay="200">
                    <div
                        class="w-20 h-20 mx-auto flex items-center justify-center bg-purple-100 text-purple-600 rounded-full mb-4">
                        <i class="fas fa-lightbulb text-3xl"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-800 mb-2">Innovation</h3>
                    <p class="text-gray-600">We constantly seek better ways to solve problems, embracing creativity and
                        new technologies to stay ahead.</p>
                </div>
                <div class="text-center p-6" data-aos="fade-up" data-aos-delay="300">
                    <div
                        class="w-20 h-20 mx-auto flex items-center justify-center bg-secondary-100 text-secondary-600 rounded-full mb-4">
                        <i class="fas fa-handshake text-3xl"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-800 mb-2">Integrity</h3>
                    <p class="text-gray-600">We operate with honesty and transparency, building trust with our customers,
                        partners, and each other.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-16 sm:py-20 bg-indigo-700 text-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center" data-aos="zoom-in">
            <h2 class="text-3xl font-bold text-white">Join Us on Our Journey</h2>
            <p class="mt-4 text-lg text-[#F5F5F5] max-w-3xl mx-auto">
                Ready to experience the future of payments? Explore our features or get in touch with our team to learn
                more.
            </p>
            <div class="mt-8">
            <a href="<?php echo e(route('register')); ?>"
                class="btn btn-primary btn-lg no-underline btn-get-started px-6 py-1 sm:px-8 sm:py-2 shadow-none inline-flex items-center justify-center text-center">Get
                Started</a>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            AOS.init({
                duration: 800,
                easing: 'ease-in-out',
                once: true
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\hilnexpay\resources\views/frontend/about.blade.php ENDPATH**/ ?>