<section class="section">

    <div class="row ">
        <div class="col-xl-3 col-lg-6">
            <div class="card l-bg-style1">
                <div class="card-statistic-3">
                    <div class="card-icon card-icon-large"><i class="fa fa-dollar-sign"></i></div>
                    <div class="card-content">
                        <h4 class="card-title">Balance</h4>
                        <span><?= currency_format(current_user('balance')); ?></span>
                        <div class="progress mt-1 mb-1" data-height="8" style="height: 8px;">
                            <div class="progress-bar l-bg-purple" role="progressbar" data-width="100%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 100%;"></div>
                        </div>
                        <p class="mb-0 text-sm">
                            <span class="mr-2"><i class="fa fa-arrow-up"></i> </span>
                            <span class="text-nowrap">Deposit Your Income</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-6">
            <div class="card l-bg-style2">
                <div class="card-statistic-3">
                    <div class="card-icon card-icon-large"><i class="fa fa-briefcase"></i></div>
                    <div class="card-content">
                        <h4 class="card-title">Successful Transaction</h4>
                        <span class="success_trx"></span>
                        <div class="progress mt-1 mb-1" data-height="8" style="height: 8px;">
                            <div class="progress-bar l-bg-orange" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                        </div>
                        <p class="mb-0 text-sm">
                            <span class="mr-2"><i class="fa fa-arrow-up"></i>Total Succesful transaction</span>
                            <span class="text-nowrap total_success_trx">0</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-6">
            <div class="card l-bg-style3">
                <div class="card-statistic-3">
                    <div class="card-icon card-icon-large"><i class="fa fa-globe"></i></div>
                    <div class="card-content">
                        <h4 class="card-title">Pending Transaction</h4>
                        <span class="pending_trx">0</span>
                        <div class="progress mt-1 mb-1" data-height="8" style="height: 8px;">
                            <div class="progress-bar l-bg-cyan" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                        </div>
                        <p class="mb-0 text-sm">
                            <span class="mr-2"><i class="fa fa-arrow-up"></i>Total Pending</span>
                            <span class="text-nowrap total_pending_trx">0</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-lg-6">
            <div class="card l-bg-style4">
                <div class="card-statistic-3">
                    <div class="card-icon card-icon-large"><i class="fa fa-money-bill-alt"></i></div>
                    <div class="card-content">
                        <h4 class="card-title">Payments</h4>
                        <span class="earning">0</span>
                        <div class="progress mt-1 mb-1" data-height="8" style="height: 8px;">
                            <div class="progress-bar l-bg-green" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                        </div>
                        <p class="mb-0 text-sm">
                            <span class="mr-2"><i class="fa fa-arrow-up"></i> Total Payment</span>
                            <span class="text-nowrap total_earning">0</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card gradient-bottom">
                <div class="card-header">
                    <h4>Transactions</h4>
                    <div class="card-header-action dropdown">
                        <a href="#" id="dropdownMenuButton" data-bs-toggle="dropdown" class="btn btn-danger dropdown-toggle">Period</a>
                        <ul class="dropdown-menu dropdown-menu-sm dropdown-menu-right" aria-labelledby="dropdownMenuButton">
                            <li class="dropdown-title">Select Period</li>
                            <li><a href="#" class="dropdown-item mydrp active" data-period="today">Today</a></li>
                            <li><a href="#" class="dropdown-item mydrp" data-period="week">Week</a></li>
                            <li><a href="#" class="dropdown-item mydrp" data-period="month">Month</a></li>
                            <li><a href="#" class="dropdown-item mydrp" data-period="year">This Year</a></li>
                        </ul>
                    </div>
                </div>
                <div class="card-body" id="top-5-scroll" style="height: 380px; overflow: hidden; outline: none;" tabindex="3">
                    <ul id="type-list" class="list-unstyled list-unstyled-border" style="position: relative; max-height: 320px;"></ul>
                </div>
                <div class="card-footer pt-3 d-flex justify-content-center">
                    <div class="budget-price justify-content-center">
                        <div class="budget-price-square bg-primary" data-width="20" style="width: 20px;"></div>
                        <div class="budget-price-label">Successful Transaction</div>
                    </div>
                    <div class="budget-price justify-content-center">
                        <div class="budget-price-square bg-danger" data-width="20" style="width: 20px;"></div>
                        <div class="budget-price-label">Pending Transaction</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    function get_dashboard_values(period) {
        $.post("<?= user_url('dashboard-data') ?>", {
            token: token,
            period: period
        }, function(result) {
            var data = jQuery.parseJSON(result);
            $.each(data, function(index, element) {
                $("." + index).html(element);
            });

            // Update the list items
            $('#type-list').html(data.listItems);
        });
    }

    $(document).ready(function() {
        var initialPeriod = $('.mydrp.active').data('period');
        get_dashboard_values(initialPeriod);
        $('.mydrp').on('click', function(e) {
            e.preventDefault();
            $('.mydrp').removeClass('active');
            $(this).addClass('active');
            var period = $(this).data('period');
            get_dashboard_values(period);
        });
    });
</script>